/*
  * Util defines and templates written by me before the GCJ2008 contest started
  * Andre Susano Pinto <andresusanopinto@gmail.com>
  */
 #include <vector>
 #include <list>
 #include <map>
 #include <set>
 #include <deque>
 #include <stack>
 #include <bitset>
 #include <algorithm>
 #include <functional>
 #include <numeric>
 #include <utility>
 #include <sstream>
 #include <iostream>
 #include <iomanip>
 #include <cstdio>
 #include <cmath>
 #include <cstdlib>
 #include <ctime>
 #include <queue>
 #include <cfloat>
 #include <queue>
 #include <climits>
 #include <cassert>
 #include <string.h>
 #define join(a,b) a##b
 #define EP (1e-9)
 
 typedef unsigned int uint32;
 typedef unsigned long long uint64;
 
 using namespace std;
 
 template<typename T> typename T::iterator IterBegin(T &t) { return t.begin(); }
 template<typename T> typename T::iterator IterEnd  (T &t) { return t.end(); }
 template<typename T,int S> T* IterBegin(T (&t)[S]) { return t+0; }
 template<typename T,int S> T* IterEnd  (T (&t)[S]) { return t+S; }
 
 template<typename T> typename T::const_iterator IterBegin(const T &t) { return t.begin(); }
 template<typename T> typename T::const_iterator IterEnd  (const T &t) { return t.end(); }
 template<typename T,int S> const T* IterBegin(const T (&t)[S]) { return t+0; }
 template<typename T,int S> const T* IterEnd  (const T (&t)[S]) { return t+S; }
 
 template<typename T> int size(const T &t) { return t.size(); }
 template<typename T, int S> int size(const T (&t) [S]) { return S; }
 
 #define FOREACH(col, iter, end) for(__typeof( IterBegin(col) ) iter = IterBegin(col), end=IterEnd(col); iter != end; iter++)
 #define foreach(col, iter) FOREACH(col, iter, join(iter, __end))
 #define all(col)    IterBegin(col), IterEnd(col)
 
 #define x first
 #define y second
 
 template<typename T> T read()
 {
 	T t;
 	cin >> t;
 //	cerr << "read: " << t << endl;
 	return t;
 }
 
 int readtime()
 {
 	int a, b;
 	char t;
 	cin >> 	a >> t >> b;
 	return a*60 + b;
 }
 
 string readline()
 {
 	string line;
 	getline(cin, line);
 	return line;
 }
 
 template <typename T> inline void reset(T &t, const T &val) { t = val; }
 template <typename T, int S> void reset(T (&t) [S], const T &val)
 {
 	for(int i=0; i<S; i++) reset(t[i], val);
 }
 
 vector<string> parse_strings(const string &s)
 {
 	istringstream is( s);
 	string t;
 	vector<string> vs;
 	while(is >> t) vs.push_back(t);
 	return vs;
 }
 
 void solve();
 
 int main()
 {
 	int cases;
 	cin >> cases; cin.ignore();
 	for(int i=1; i<=cases; i++)
 	{
 		cout << "Case #" << i << ": ";
 		solve();
 	}
 	return 0;
 }
 
 
 /*
  * Code itself
  */
 int S(long long a, long long b)
 {
 	return (a+b) % 10007;
 }
 
 void solve()
 {
 	bool bad[200][200] = {};
 	long long ways[200][200] = {};
 	int W, H, R;
 	cin >> W >> H >> R;
 
 	for(int i=0; i<R; i++)
 	{
 		int r, c;
 		cin >> r >> c;
 		bad[r-1][c-1] = true;
 	}
 
 	ways[0][0] = 1;
 	for(int i=0; i<W; i++)
 	for(int j=0; j<H; j++)
 
 	if(bad[i][j] == false)
 	{
 		ways[i+2][j+1] = S( ways[i+2][j+1], ways[i][j] );
 		ways[i+1][j+2] = S( ways[i+1][j+2], ways[i][j] );
 	}
 	
 
 	cout << ways[W-1][H-1] << endl;
 }
 
