/*
  *  Created on: Sep 26, 2009
  *      Author: Ramesh Rajaby
  */
 
 #include <iostream>
 #include <cassert>
 
 using namespace std;
 
 const int INF = 1000000000;
 
 
 char cave[13][10];
 int R, C, F;
 int cache[13][10][64][64];
 
 
 bool canDig(int r, int c) {
 	return cave[r][c] == '#' && cave[r-1][c] == '.';
 }
 int getNewRow(int r, int c) {
 	while (cave[r+1][c] == '.' && r < R) {
 		r++;
 	}
 	return r;
 }
 
 
 int toBin(int r) {
 	int p = 1, n = 0;
 	for (int i = C-1; i >= 0; i--) {
 		n += (cave[r][i] == '.' ? 0 : 1) * p;
 		p *= 2;
 	}
 
 	if (n >= 64) {
 		cout << C << " " << n << endl;
 	}
 	return n;
 }
 
 //0 l, 1 r, 2 n
 int solve(int r, int c, char dir) {
 	int sol = INF;
 
 	int toBinR = toBin(r);
 	int toBinR1 = toBin(r+1);
 	if (cache[r][c][toBinR][toBinR1] >= 0) {
 		return cache[r][c][toBinR][toBinR1];
 	}
 
 	if (c < 0 || c >= C) {
 		return INF;
 	}
 	if (r >= R-1) {
 		return 0;
 	}
 
 	if (cave[r][c] == '#') {
 		return INF;
 	}
 
 	if (cave[r+1][c] == '.') {
 		int newRow = getNewRow(r, c);
 		if (newRow - r <= F) {
 			sol = min(sol, solve(newRow, c, 2));
 		} else {
 			return INF;
 		}
 	}
 
 	if (dir != 0) {
 		sol = min(sol, solve(r, c-1, 1));
 	}
 	if (dir != 1) {
 		sol = min(sol, solve(r, c+1, 0));
 	}
 
 	if (canDig(r+1, c+1)) {
 		cave[r+1][c+1] = '.';
 		sol = min(sol, 1 + solve(r, c, dir));
 		cave[r+1][c+1] = '#';
 	}
 	if (canDig(r+1, c-1)) {
 		cave[r+1][c-1] = '.';
 		sol = min(sol, 1 + solve(r, c, dir));
 		cave[r+1][c-1] = '#';
 	}
 
 	return cache[r][c][toBinR][toBinR1] = sol;
 }
 
 
 int main() {
 	int n;
 
 	cin >> n;
 	for (int t = 0; t < n; t++) {
 		for (int i = 0; i < 12; i++)
 			for (int j = 0; j < 8; j++)
 				for (int k1 = 0; k1 < 64; k1++)
 					for (int k2 = 0; k2 < 64; k2++)
 						cache[i][j][k1][k2] = -1;
 
 		cin >> R >> C >> F;
 		for (int i = 0; i < R; i++) {
 			for (int j = 0; j < C; j++) {
 				cin >> cave[i][j];
 			}
 		}
 
 		int s = solve(0, 0, 0);
 		cout << "Case #" << t+1 << ": ";
 		if (s == INF) {
 			cout << "No" << endl;
 		} else {
 			cout << "Yes " << s << endl;
 		}
 	}
 }
 
