#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <math.h>
 
 #include <iostream>
 #include <algorithm>
 #include <set>
 #include <vector>
 #include <list>
 
 #define MAX 64
 #define MAXR 16
 #define MAXC 8
 #define MAXCC (1 << MAXC)
 #define MAXA (MAXR * MAXC)
 
 using namespace std;
 
 struct QUEUE {
 	int x, y, now, next, w;
 }queue[MAXR * MAXC * MAXCC * MAXCC];
 
 int r, c, f;
 int use[MAX][MAX], countq;
 char map[MAX][MAX];
 int tmp[MAXR][MAXC][MAXCC][MAXCC];
 int ans;
 
 void reset_data() {
 	int i, j, x, y;
 
 	ans = MAXA;
 
 	for(i = 0; i < MAXR; i++)
 		for(j = 0; j < MAXC; j++)
 			for(x = 0; x < MAXCC; x++)
 				for(y = 0; y < MAXCC; y++)
 					tmp[i][j][x][y] = MAXA;
 
 	for(i = 0; i < r; i++)
 		for(j = 0; j < c; j++)
 			use[i][j] = 0;
 }
 
 int parse(int l) {
 	int i, sum = 0;
 
 	for(i = 0; i < c; i++)
 		sum += (1 << i) * ((map[l][i] == '#') ? 1 : 0);
 	return sum;
 }
 
 void walk(int x, int y, int now, int next, int w) {
 	if(tmp[x][y][now][next] != MAXA)return;
 	tmp[x][y][now][next] = w;
 
 	if(x == r - 1) {
 		if(w < ans)
 			ans = w;
 		return;
 	}
 
 	queue[countq].x = x;
 	queue[countq].y = y;
 	queue[countq].now = now;
 	queue[countq].next = next;
 	queue[countq].w = w;
 	countq++;
 }
 
 void cal(int x, int y, int now, int next, int w) {
 	int i, j;
 
 	if(y > 0) {
 		if(!(now & (1 << (y - 1))))
 			if(next & (1 << (y - 1)))
 				walk(x, y, now, next - (1 << (y - 1)), w + 1);
 	}
 	if(y < c - 1) {
 		if(!(now & (1 << (y + 1))))
 			if(next & (1 << (y + 1)))
 				walk(x, y, now, next - (1 << (y + 1)), w + 1);
 	}
 
 	for(i = y; i >= 0; i--) {
 		if(now & (1 << i))break;
 		if(next & (1 << i)) {
 			walk(x, i, now, next, w);
 		} else {
 			for(j = x + 2; j < r; j++)
 				if(map[j][i] == '#')break;
 			j--;
 			if(j - x > f)break;
 			if(j == x + 1)
 				walk(j, i, next, parse(j + 1), w);
 			else walk(j, i, parse(j), parse(j + 1), w);
 			break;
 		}
 	}
 	for(i = y; i < c; i++) {
 		if(now & (1 << i))break;
 		if(next & (1 << i)) {
 			walk(x, i, now, next, w);
 		} else {
 			for(j = x + 2; j < r; j++)
 				if(map[j][i] == '#')break;
 			j--;
 			if(j - x > f)break;
 			if(j == x + 1)
 				walk(j, i, next, parse(j + 1), w);
 			else walk(j, i, parse(j), parse(j + 1), w);
 			break;
 		}
 	}
 }
 
 void find_ans() {
 	int i, j;
 
 	reset_data();
 
 	scanf("%d %d %d", &r, &c, &f);
 	for(i = 0; i < r; i++)
 		scanf("%s", map[i]);
 
 	/*for(i = 0; i < r; i++)
 		if(map[i][0] == '#')break;
 	i--;*/
 
 	countq = 1;
 	queue[0].x = 0;
 	queue[0].y = 0;
 	queue[0].now = parse(0);
 	queue[0].next = parse(1);
 	queue[0].w = 0;
 	tmp[queue[0].x][queue[i].y][queue[i].now][queue[i].next] = queue[0].w;
 
 	for(i = 0; i < countq; i++) {
 		//printf("\n%d %d %d %d %d\n", queue[i].x, queue[i].y, queue[i].now, queue[i].next, queue[i].w);
 		cal(queue[i].x, queue[i].y, queue[i].now, queue[i].next, queue[i].w);
 	}
 
 	if(ans == MAXA) {
 		printf("No");
 	} else {
 		printf("Yes %d", ans);
 	}
 }
 
 int main(int argc, char *argv[])
 {
 	int i, c;
 
 	scanf("%d", &c);
 	for(i = 1; i <= c; i++) {
 		printf("Case #%d: ", i);
 		find_ans();
 		printf("\n");
 	}
 
 	return 0;
 }
