#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 #define DEBUG 0
 
 struct Node_t{
   int numChildren;
   char name[228];
   struct Node_t *child[228];
 }; 
 
 
 
 typedef struct Node_t Node_t;
 
 Node_t nodes[1024];
 int numnodes;
 
 void print(Node_t *n,char* prefix)
 {
   int i,j;
   printf("%s %s\n",prefix,n->name);
 
   for(i=0;prefix[i] != 0;i++);
   for(j=0;j<4;j++)
     prefix[j+i] = ' ';
   prefix[j+i] = 0;
   for(i=0;i<n->numChildren;i++)
     print(n->child[i],prefix);
 }
 
 int addDirectory(char* name,Node_t *node)
 {
   char dir[200];
   int i,j,k;
   
   for(i=1;;i++)
     {
       if(name[i] == '/' || name[i] == 0) 
 	{
 	  dir[i-1] = 0;
 	  if(DEBUG)
 	    {
 	      printf("%s\n",name);
 	      printf("%s\n",dir);
 	    }
 	  for(j=0;j<node->numChildren;j++)
 	    {
 	      if(strcmp(node->child[j]->name,dir) == 0)
 		{
 		  for(k=0;name[k+i] != 0;k++)
 		    dir[k] = name[k+i];
 		  dir[k] = 0;
 		  if(name[i] == 0) return 0;
 		  else return addDirectory(dir,node->child[j]);
 		}
 	    }
 	  if(j >= node->numChildren)
 	    {
 	      Node_t *n = &nodes[numnodes]; numnodes++;
 	      memcpy(n->name,dir,strlen(dir)+1);
 	      if(DEBUG) printf("ADDING: %s\n",n->name);
 	      n->numChildren = 0;
 	      node->child[node->numChildren] = n;
 	      node->numChildren++;
 
 	      for(k=0;name[k+i] != 0;k++)
 		dir[k] = name[k+i];
 	      dir[k] = 0;
 	      if(name[i] == 0) return 1;
 	      else return 1 + addDirectory(dir,n);
 	    }	 
 	}
       else
 	dir[i-1] = name[i];
     }
 }
 
 int main(int argc,char* argv[]) {
   int t = 0;
   int i;
 
   FILE *fp = fopen(argv[1],"r");
   fscanf(fp,"%i",&t);
 
 
   for(i=0;i<t;i++)
     {
       Node_t root;
       root.numChildren = 0;
       root.name[0] = 0;
       numnodes = 0;
       int numDirs;
       int numToMake;
       fscanf(fp,"%i %i",&numDirs,&numToMake);
       int n,m;
       for(n = 0;n<numDirs;n++)
 	{
 	  char name[200];
 	  fscanf(fp,"%s",name);
 	  addDirectory(name,&root);
 	  if(DEBUG)
 	    {
 	      char pre[100];
 	      pre[0] = 0;
 	      print(&root,pre);	  
 	    }
 	}
       if(DEBUG) 
 	{
 	  printf("Part 1 Done ------------\n");
 	  char pre[100];
 	  pre[0] = 0;
 	    print(&root,pre);	  
 	}
       int sum = 0;
       for(m = 0;m<numToMake;m++)
 	{
 	  char name[200];
 	  fscanf(fp,"%s",name);
 	  //printf("%s\n",name);
 	  sum += addDirectory(name,&root);
 	}
 
       //printf("n:%i k:%i onState: %i state: %i\n",n,k,onState,state);
       printf("Case #%i: %i\n",i+1,sum);
 
     }
   return 0;
 }
