#include<iostream>
 
 using namespace std;
 
 int max(int i, int j)
 {
 	return i > j ? i : j;
 }
 void swap(int *i, int *j)
 {
 	int temp;
 	temp = *i;
 	*i = *j;
 	*j = temp;
 }
 
 int  _mergeSort(int arr[], int temp[], int left, int right);
 int merge(int arr[], int temp[], int left, int mid, int right);
 
 /* This function sorts the input array and returns the
 number of inversions in the array */
 int mergeSort(int arr[], int array_size)
 {
 	int *temp = (int *)malloc(sizeof(int)*array_size);
 	return _mergeSort(arr, temp, 0, array_size - 1);
 }
 
 /* An auxiliary recursive function that sorts the input array and
 returns the number of inversions in the array. */
 int _mergeSort(int arr[], int temp[], int left, int right)
 {
 	int mid, inv_count = 0;
 	if (right > left)
 	{
 		/* Divide the array into two parts and call _mergeSortAndCountInv()
 		for each of the parts */
 		mid = (right + left) / 2;
 
 		/* Inversion count will be sum of inversions in left-part, right-part
 		and number of inversions in merging */
 		inv_count = _mergeSort(arr, temp, left, mid);
 		inv_count += _mergeSort(arr, temp, mid + 1, right);
 
 		/*Merge the two parts*/
 		inv_count += merge(arr, temp, left, mid + 1, right);
 	}
 	return inv_count;
 }
 
 /* This funt merges two sorted arrays and returns inversion count in
 the arrays.*/
 int merge(int arr[], int temp[], int left, int mid, int right)
 {
 	int i, j, k;
 	int inv_count = 0;
 
 	i = left; /* i is index for left subarray*/
 	j = mid;  /* j is index for right subarray*/
 	k = left; /* k is index for resultant merged subarray*/
 	while ((i <= mid - 1) && (j <= right))
 	{
 		if (arr[i] <= arr[j])
 		{
 			temp[k++] = arr[i++];
 		}
 		else
 		{
 			temp[k++] = arr[j++];
 
 			/*this is tricky -- see above explanation/diagram for merge()*/
 			inv_count = inv_count + (mid - i);
 		}
 	}
 
 	/* Copy the remaining elements of left subarray
 	(if there are any) to temp*/
 	while (i <= mid - 1)
 		temp[k++] = arr[i++];
 
 	/* Copy the remaining elements of right subarray
 	(if there are any) to temp*/
 	while (j <= right)
 		temp[k++] = arr[j++];
 
 	/*Copy back the merged elements to original array*/
 	for (i = left; i <= right; i++)
 		arr[i] = temp[i];
 
 	return inv_count;
 }
 
 int *revArray(int *array, int size)
 {
 	for (int i = 0; i < size / 2;i++)
 	{
 		swap(&array[i], &array[size - i - 1]);
 	}
 	return array;
 }
 
 
 int main()
 {
 	int t;
 	int n;
 	int arr[100];
 	int *ar;
 	int c;
 	int max_till_now;
 
 	cin>>t;
 	for (int l = 0; l < t; l++)
 	{
 		cin>>n;
 		max_till_now = 0;
 		for (int counter = 1; counter <= n; counter++)
 		{
 			c = 0;
 			int j = counter;
 			while (j != 0)
 			{
 				int mod = j % 10;
 				arr[c++] = mod;
 				j = j / 10;
 			}
 			
 
 			revArray(arr, c);
 			int i = mergeSort(arr, c);
 			if (i==0)
 			{
 				max_till_now = counter;
 			}
 		}
 		cout<<"Case #"<<l+1<<": "<< max_till_now<<endl;
 	}
 	return 0;
 }