#include <iostream>
 #include <cmath>
 #define DEBUG 0
 
 // forward declarations
 bool tidyCheck(unsigned long long int i);
 int calcNumPlaces(unsigned long long int i);
 unsigned long long int findPrevTidy(unsigned long long int i);
 unsigned long long int findBigPrevTidy(unsigned long long int i);
 unsigned long long int turnRightSideZero(unsigned long long int i, int places);
 
 void tidycheck_problem()
 {
 	unsigned long long int numProblems = 0;
 	std::cin >> numProblems;
 
 	for (int i = 0; i < numProblems; i++) {
 		unsigned long long int num;
 		std::cin >> num;
 		unsigned long long int solution = findPrevTidy(num);
 
 		std::cout << "case #" << i + 1 << ": " << solution << std::endl;
 	}
 }
 
 unsigned long long int findPrevTidy(unsigned long long int i)
 {
 	if (i > 1000) {
 		i = findBigPrevTidy(i);	// returns either a tidy number or close to a tidy number
 #if DEBUG
 		std::cout << "findBigPrevTidy: " << i << std::endl;
 #endif
 	}
 
 	while (!tidyCheck(i)) {
 		--i;
 	}
 
 	return i;
 }
 
 unsigned long long int findBigPrevTidy(unsigned long long int i)
 {
 	unsigned long long int num = i;			// copy number
 	int places = calcNumPlaces(num);		// calculate number of places to read from left to right
 	int origPlaces = places;				// copy places
 #if DEBUG
 	std::cout << "Initiating findBigPrevTidy. Num places: " << places << std::endl;
 #endif
 
 	unsigned long long int tens = pow(10, places - 1);	// get ten's multiple equivalent to number
 	int leftNum = num / tens;				// get leftmost number
 	int prevNum = 0;
 	num -= tens * leftNum;					// erase leftmost number
 	--places;								// adjust places
 
 	while (places != 0) {
 		tens = pow(10, places - 1);			// get ten's multiple
 		int nextNum = num / tens;			// get next number
 		num -= tens * nextNum;				// erase leftmost number
 		--places;							// adjust places
 
 		if (nextNum < leftNum) {			// if nextNum < leftNum, will need to reduce number by a large amount
 			if (leftNum > prevNum)
 				return turnRightSideZero(i, places+1);	// turn all numbers after it to 0 then return this number
 			else
 				return turnRightSideZero(i, origPlaces-1);	// need to turn everything from significant digit to right to 0
 		}
 		else
 			prevNum = leftNum;
 			leftNum = nextNum;				// replace numbers
 	}
 
 	return i;
 }
 
 unsigned long long int turnRightSideZero(unsigned long long int i, int places)
 {
 	int origPlaces = calcNumPlaces(i);		// store number of places of number
 	unsigned long long int newNum = 0;
 	while (origPlaces != places) {
 		// get leftmost number of i
 		unsigned long long int tens = pow(10, origPlaces-1);
 		int leftNum = i / tens;
 		i -= tens * leftNum;					// adjust number
 		--origPlaces;
 
 		// add to the new number to be returned
 		newNum += tens * leftNum;
 	}
 
 	return newNum;
 }
 
 bool tidyCheck(unsigned long long int i)
 {
 	unsigned long long int x = i % 10;// get ones place
 	i /= 10;			// remove ones place
 
 	while (i != 0) {	// if i is a single digit, loop doesn't proceed
 		unsigned long long int y = i % 10;	// get next number
 		i /= 10;		// remove from number
 		if (x < y)		// if ones place is less than next, not a tidy number
 			return false;
 		else
 			x = y;		// prepare for next loop iteration
 	}
 
 	return true;
 }
 
 int calcNumPlaces(unsigned long long int i)
 {
 	int places = 0;
 	while (i != 0) {
 		i /= 10;
 		++places;
 	}
 
 	return places;
 }
 
 int main()
 {
 	tidycheck_problem();
 
 	std::cin.get();
 	std::cin.get();
 
 	return 0;
 }