#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <gmp.h>
 
 void chopString(char *st)
 {
 char *p=strchr(st, '\n');
 if (p) *p='\0';
 p=strchr(st, '\r');
 if (p) *p='\0';
 }
 
 // // // // // // // // // // 
 
 int NotTidy(char *st)
 {
 char *p;
 for (p=st+strlen(st)-1; p>st; p--)
 	{
 	//printf("controllo [%c] con [%c]\n", p[-1], p[0]);
 	if (p[-1] > *p)
 		{
 		return p-st;
 		}
 	}
 return 0;
 }
 
 // // // // // // // // // // 
 
 void ElaboraCaso(long caso, FILE *fl)
 {
 char	riga[2048];
 
 if (!fgets(riga, sizeof(riga), fl))
 	{
 	fprintf(stderr, "Finito File\n");
 	exit(1);
 	}
 chopString(riga);
 printf("Case #%d: ", caso);
 
 
 mpz_t curr;
 mpz_init_set_str(curr, riga, 10);
 
 char out[1024];
 
 mpz_get_str(out, 10, curr);
 
 int prb;
 
 while ((prb=NotTidy(out)) > 0)
 	{
 	fprintf(stderr, "caso%d test[%.*s|%s]", caso, prb, out, out+prb);
 	// metto a zero tutte le cifre dopo quella incriminata
 	char *p;
 	for (p=out+prb; *p; p++) *p='0';
 	fprintf(stderr, "==> [%s]", out);
 
 	mpz_set_str(curr, out, 10);
 	mpz_sub_ui(curr, curr, 1);
 	mpz_get_str(out, 10, curr);
 	fprintf(stderr, "==> test[%s]\n", out);
 	}
 
 printf("%s\n", out);
 
 }
 
 // // // // // // // // // // 
 
 int main(int argc, char *argv[])
 {
 if (argc != 2)
 	{
 	printf("Usa %s <file_input>\n", argv[0]);
 	return 1;
 	}
 
 FILE *fl;
 
 fl=fopen(argv[1], "r");
 if (!fl)
 	{
 	perror("Aprendo file input");
 	return 1;
 	}
 long T;
 char riga[1024];
 fgets(riga, sizeof(riga), fl);
 T=atol(riga);
 
 long i;
 for (i=0; i < T; i++)
 	{
 	ElaboraCaso(i+1, fl);
 	}
 }
