#include <stdlib.h>
 #include <stdio.h>
 #include <string.h>
 #include <assert.h>
 
 int extra_zeros(char* src, int length)
 {
   int i;
   for(i=0;i<length;i++){
     if (src[i] != '0')
       return i;
   }
   return length-1;//in case they give me 0
 }
 
 void dec_digit(char* src, int pos)
 {
   if ((src[pos] == '0') || (pos>0 && src[pos] == src[pos-1])) {
     src[pos] = '9';
     assert(pos>0); //can't be pos 1 
     dec_digit(src, --pos);
   }
   else {
     src[pos]--;
   }
 }
 
 void set_nines(char* src, int start, int length)
 {
   int i;
   for(i=start;i<length;i++){
     src[i] = '9';
   }
 }
 
 int first_issue(char* src, int length)
 {
   int i;
   for(i=1;i<length;i++){
     if (src[i-1]>src[i])
       return i;
   }
   return length;
 }
 
 int main ( int argc, char *argv[]) 
 { 
   char line[255];
   FILE *in, *out;
   int trial = 1;
   int length, pos, zeros, ntrials;
 
   assert(argc > 2);
   in = fopen( argv[1], "r" );
   out = fopen( argv[2], "w" );
 
   fscanf(in, "%d", &ntrials);
   for (trial=1;trial<=ntrials;trial++) {
     fscanf(in, "%s", line);
     length = strlen(line);    
     pos = first_issue(line, length);
     if (pos < length) {
       set_nines(line, pos, length);
       dec_digit(line, pos-1);
     }
     zeros = extra_zeros(line, length);
     fprintf(out, "Case #%d: %s\n", trial, line+zeros);
   }
 
 }
