#include <iostream>
 #include <string>
 #include <cmath>
 #include <vector>
 #include <fstream>
 #include <sstream>
 using namespace std;
 
 string decrementString(string n) {
   for(int i = n.length() - 1; i > 0; i--) {
     if(n[i] == '0') {
       n[i] = '9';
     } else {
       n[i]--;
       return n;
     }
   }
 
   if(n[0] == '1') {
     return n.substr(1, n.length());
   } else {
     n[0]--;
     return n;
   }
 }
 
 bool checkNumberOrder(string n) {
   for(int i = 0; i < n.length() - 1; i++) {
     if(n[i] > n[i + 1]) {
       return false;
     }
   }
 
   return true;
 }
 
 string fixNumber(string n, int i) {
   if(i == 1) {
     n = n.substr(1, n.length());
     for(int j = 0; j < n.length(); j++) {
       n[j] = '9';
     }
   } else {
     n[i - 1] = n[i];
     for(; i < n.length(); i++) {
       n[i] = '9';
     }
   }
   return n;
 }
 
 string fixProblem(string n) {
   int i;
   bool problem = true;
   while(problem) {
     problem = false;
     for(int i = n.length() - 1; i > 0; i--) {
       if(n[i] < n[i - 1]) {
         problem = true;
         n = fixNumber(n, i);
         break;
       }
     }
   }
 
   return n;
 }
 
 int main() {
   ifstream in("B-large.in");
   streambuf *cinbuf = cin.rdbuf();
   cin.rdbuf(in.rdbuf());
 
   ofstream out("B-large.out");
   streambuf *coutbuf = cout.rdbuf(); //save old buf
   cout.rdbuf(out.rdbuf());
 
   int t;
   string n;
   bool orderCheck;
 
   cin >> t;
   for(int i = 1; i <= t; i++) {
     cin >> n;
     orderCheck = false;
     while(!orderCheck) {
       orderCheck = checkNumberOrder(n);
       if(orderCheck == true)
         break;
 
       n = fixProblem(n);
     }
 
     cout << "Case #" << i << ": " << n << endl;
   }
   return 0;
 }
