/*
  * main.c
  *
  *  Created on: Apr 8, 2017
  *      Author: Phil
  */
 
 #include <stdio.h>
 #include <stdlib.h>
 #include <stdbool.h>
 #include <math.h>
 
 unsigned long long pow_long(unsigned long long base, unsigned long long exponent){
 	if(exponent == 0){
 		return 1;
 	}
 
 	unsigned long long result = base;
 	int length = floor(log2(exponent)) + 1;
 
 	for(int i = length - 2; i >= 0; i--){
 		result = result * result;
 		if((exponent >> i) % 2 == 1){
 			result *= base;
 		}
 	}
 
 	return result;
 }
 
 unsigned long long compute_next_tidy_number(unsigned long long number){
 	int digit1, digit2;
 	bool change = true;
 	int length = floor(log10(number)) + 1;
 
 	while(change){
 		change = false;
 		for(int i = 0; i < length; i++){
 			for(int j = i+1; j < length; j++){
 				digit1 = (number / pow_long(10, i)) % 10;
 				digit2 = (number / pow_long(10, j)) % 10;
 
 				if(digit1 < digit2){
 					number = number - (number % pow_long(10, i+1))-1;
 					change = true;
 				}
 			}
 		}
 	}
 
 	return number;
 }
 
 int main(int argc, char *argv[]){
 	FILE *f_in = fopen(argv[1], "r");
 	FILE *f_out = fopen("out.txt", "w");
 
 	int cases;
 	unsigned long long result;
 
 	unsigned long long number;
 
 	fscanf(f_in, "%d", &cases);
 
 	for(int i = 0; i < cases; i++){
 		fscanf(f_in, "%llu", &number);
 
 		result = compute_next_tidy_number(number);
 		fprintf(f_out, "Case #%d: %llu\n", i+1, result);
 	}
 }
