#include <stdio.h>
 #include <stdbool.h>
 
 /* We store the long long int in dividedInput in reverse, ie the last digit is in dividedInput[0], second last is in
    dividedInput[1], and so on... */
 bool isTidy( unsigned char x[], int size ) {
   int i;
   bool isTidy=true;
   unsigned char presentHighestDigit=10, digitBeingAnalyzed;
   for( i=0; i<(size-1); i++ ) {
     if( x[i]<x[i+1] ) {
       isTidy=false;
       break;
     }
   }
   return isTidy;
 }
 
 void divideInput( long long int input, unsigned char* output, int* size ) {
   *size = 0;
   unsigned char analyzingDigit;
   int i=0;
   while( input!=0 ) {
     analyzingDigit = (unsigned char)( input%10 );
     *(output+i) = analyzingDigit;
     (*size)++;
     input/=10;
     i++;
   }
 }
 
 void findLastTidyNumber( unsigned char* input, int size ) {
   int i=0, j;
   if( size==1 ) return;
   else {
     for(i=0; i<size; i++ ) {
         if( input[i]<input[i+1] ) {
           input[i]=9;
           if( input[i+1]>0 ) input[i+1]--;
         }
     }
     for( i=0; input[i]!=9; i++ ) input[i] = 9;
   }
 }
 
 long long int convertDividedInputToInteger( unsigned char x[], int size ) {
   long long int result=0;
   int i;
   for( i=size-1; i>=0; i-- ) {
     result*=10;
     result+=x[i];
   }
   return result;
 }
 
 
 
 int main(){
   freopen("B-large.in.txt", "r", stdin);
   freopen("B-large.out.txt", "w", stdout);
 
   long long int input;
   int size, i, T;
   unsigned char dividedInput[20] = {0};
   unsigned char answer[20] = {0};
   scanf("%d", &T);
   for(i=1;i<=T;i++) {
     scanf("%lld", &input);
     divideInput( input, dividedInput, &size );
     findLastTidyNumber( dividedInput, size );
     printf("Case #%d: %lld\n", i, convertDividedInputToInteger( dividedInput, size ) );
   }
   return 0;
 }
