#include <stdio.h>
 #include <string.h>
 
 unsigned long
 isTidyNum(unsigned long num) {
     unsigned long remain, next_remain;
     while (num != 0) {
         remain = num % 10;
         num = (num/10);
         next_remain = num % 10;
         if (num != 0 && next_remain > remain) {
             return 0;
         }
     }
     return 1;
 }
 
 unsigned long
 getLastTidyNum(unsigned long n) {
     for (unsigned long i = n; i > 0; i--) {
         if (isTidyNum(i)) {
             return i;
         }
     }
 }
 
 int
 main(int argc, char* argv[]) {
     FILE *ifp;
     FILE *ofp;
     if (argc != 2) {
         printf("usage: %s input.txt\n", argv[0]);
         return 1;
     }
 
     char outfile[1024];
     strcpy(outfile, argv[1]);
     strcpy(strchr(outfile, '.'), ".out");
     printf("filename: %s, outfile: %s\n", argv[1], outfile);
 
     ifp = (FILE *) fopen(argv[1], "r");
     ofp = (FILE *) fopen(outfile, "w");
 
     int count;
     unsigned long n, result;
     
     fscanf(ifp, "%d", &count);
     for (int i=0; i<count; i++) {
         fscanf(ifp, "%lu", &n);
 
         result = getLastTidyNum(n);
 
         printf("Case #%d: %lu\n", (i+1), result);
         fprintf(ofp, "Case #%d: %lu\n", (i+1), result);
     }
 
     fclose(ifp);
     fclose(ofp);
 
     return 0;
 }
 
