#include <stdio.h>
 #include <stdlib.h>
 #include <gmp.h>
 
 double Pow(long a,long b)
 {
     long i;
     double p = 1;
     mpz_t pui;
     mpz_init_set_ui(pui,p);
     for(i=0;i<b;i++)
         mpz_mul_ui(pui,pui,a);
     return mpz_get_d(pui);
 }
 
 int main()
 {
     FILE* input = NULL;
     FILE* output = NULL;
 
     input = fopen("D-large.in","r");
     output = fopen("D-large.out","w");
 
     long i = 0;
     long j = 0;
     long k = 0;
     long T = 0;
     fscanf(input,"%ld",&T);
     fgetc(input);
     long K;
     long C;
     long S;
     for(i=0;i<T;i++)
     {
         fscanf(input,"%ld",&K);
         fscanf(input,"%ld",&C);
         fscanf(input,"%ld",&S);
         fgetc(input);
         if(C == 1)
         {
             if(S<K)
                 fprintf(output,"case #%ld: IMPOSSIBLE\n",i+1);
             else
             {
                 fprintf(output,"case #%ld: ",i+1);
                 for(j=0;j<K;j++)
                     fprintf(output,"%ld ",j+1);
                 fprintf(output,"\n");
             }
         }else
         {
             if(S<(K+1)/2)
             {
                 fprintf(output,"case #%ld: IMPOSSIBLE\n",i+1);
             }else
             {
                 fprintf(output,"case #%ld: ",i+1);
                 for(j=0;j<(K+1)/2;j++)
                 {
                     mpz_t pui;
                     mpz_init_set_ui(pui,1);
                     for(k=0;k<C-1;k++)
                     {
                         mpz_mul_ui(pui,pui,K);
                     }
 
                     mpz_t somme;
                     mpz_init_set_ui(somme,0);
 
                     mpz_add(somme,somme,pui);
 
                     mpz_sub_ui(somme,somme,1);
 
                     mpz_mul_ui(somme,somme,j);
                     mpz_add_ui(somme,somme,K);
                     mpz_out_str(output,10,somme);
                     mpz_clear(somme);
                     mpz_clear(pui);
                     fprintf(output," ");
                 }
                 fprintf(output,"\n");
             }
         }
     }
 
 }
