#include <stdio.h>
 #include <stdlib.h>
 
 #define ull unsigned long long
 
 
 ull power(ull base, ull power)
 {
 	ull answer = 1;
 	
 	for (ull i = 0; i < power; i++)
 	{
 		answer *= base;
 	}
 	
 	return answer;
 }
 
 
 void solveLess(ull k, ull c, ull s)
 {
 	ull total = power(k, c);
 	ull locs[105];
 	ull current = 0;             // # dependencies accounted for
 	ull max = k;                 // max dependencies needed
 	int i = 0;
 	
 	// find a tile
 	while ((i < s) && (current < max))
 	{
 //		printf("finding another tile current=%llu, i=%d\n", current, i);
 		ull inc = total / k;
 		locs[i] = 0;
 		
 		// calculate the index of the tile
 		for (int j = 0; (j < c) && (current < max); j++)
 		{
 //			printf("adding %llu\n", current * inc);
 			locs[i] += current * inc;
 			inc /= k;
 			current++;
 		}
 		
 		i++;
 	}
 	
 	if (current < max)
 	{
 		printf(" IMPOSSIBLE\n");
 	}
 	else
 	{
 		for (int j = 0; j < i; j++)
 		{
 			printf(" %llu", locs[j] + 1);
 		}
 		printf("\n");
 	}
 }
 
 
 int main(int argc, char* argv[])
 {
 	int ndata;
 	scanf("%d\n", &ndata);
 	
 	for (int asdf = 1; asdf <= ndata; asdf++)
 	{
 		ull k, c, s;
 		scanf("%llu %llu %llu\n", &k, &c, &s);
 		printf("Case #%d:", asdf);
 //		printf("\n");
 		
 		solveLess(k, c, s);
 		continue;
 		
 		if (s >= k)          // know can be done
 		{
 			ull inc = power(k, c) / s;
 			
 			for (ull i = 0; i < k; i++)
 			{
 				printf(" %llu", (i * inc) + 1);
 			}
 			
 			printf("\n");
 		}
 		else    // s < k
 		{
 			solveLess(k, c, s);
 		}
 	}
 }
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
