#include <iostream>
 #include <vector>
 using namespace std;
 
 typedef unsigned long long ull;
 
 ull pow(ull a, ull b) {
     if (b == 0) {
         return 1;
     }
     ull c = pow(a, b / 2);
     c = c * c;
     if (b % 2) {
         c = c * a;
     }
     return c;
 }
 
 ull evaluate(ull k, ull c) {
     ull sum = 0;
     if (c >= k - 1) {
         c = k;
     }
     for (ull i = 0, ki = 1; i < c; ++i, ki *= k) {
         sum += (c - i) * ki;
     }
     return sum;
 }
 
 ull evaluate_dynamic(ull k, ull c, ull i) {
     if (k == 1) {
         return 0;
     }
     ull kc1 = pow(k, c + 1);
     return i * (kc1 - 1) / (k - 1);
 }
 
 
 
 int main() {
     ull T, k, c, s, tc;
 
     cin >> T;
     for (tc = 1; tc <= T; ++tc) {
         cin >> k >> c >> s;
 
         vector<ull> vals;
         ull ssum = evaluate(k, c - 1);
         for (ull i = 0; i < k; i += c) {
             if (c + i > k) {
                 ull csum = min(pow(k, c), ssum + evaluate_dynamic(k, c - 1, i) + 1);
                 vals.push_back(csum);
             } else {
                 ull csum = ssum + evaluate_dynamic(k, c - 1, i) + 1;
                 vals.push_back(csum);
             }
         }
 
         cout << "Case #" << tc << ":";
         if (vals.size() > s) {
             cout << " IMPOSSIBLE";
         } else {
             for (ull i = 0; i < vals.size(); i++) {
                 cout << " " << vals[i];
             }
         }
         cout << "\n";
     }
     return 0;
 }
