#include <iostream>
 #include <fstream>
 #include <string>
 #include <vector>
 #include <list>
 #include <cmath>
 using namespace std;
 
 class TestInput{
 public:
     int k;
     int c;
     int s;
     TestInput() {
         k = 0;
         c = 0;
         s = 0;
     }
     TestInput(string inputLine) {
         int firstSpace = inputLine.find(' ');
         int secondSpace = inputLine.find(' ', firstSpace + 1);
         //cout << firstSpace << secondSpace << endl;
         k = stoi(inputLine.substr(0, firstSpace));
         c = stoi(inputLine.substr(firstSpace + 1, secondSpace - firstSpace - 1));
         s = stoi(inputLine.substr(secondSpace + 1, inputLine.length() - secondSpace - 1));
         cout << k << "->" << c << "->" << s << endl;
     }
 };
 
 list<long long> seqNumbers(int base, int complex) {
     list<long long> results;
     long long step = 0;
     for (int j = 0; j < complex; j++) {
         step += pow(base, j);
     }
     for (int i = 0; i < base; i++) {
         results.push_back(1 + i * step);
     }
     return results;
 }
 
 
 int main() {
     // BaseK(i,i,..,i/totalNum=C), is the same as the i'th in the original seq
     // C=1 LGLG
     // C=2 *L*GLG G*G*GG LG*L*G GGG*G*
     // i = 0,1,2,3,    i*K^C + i*K^(C-1) + … + i*K^0 + 1, i.e. 1+BaseK(00), 1+BaseK(11), 1+BaseK(22), 1+BaseK(33)
     // C=3 LGLG-GGGG-LGLG-GGGG     GGGG-G*G*GG-GGGG-GGGG LGLG-GGGG-LG*L*G-GGGG    GGGG-GGGG-GGGG-GGGG
     // 1+BaseK(000) = 1, 1+BaseK(111) = 22,  1+BaseK(222) = 43, 1+BaseK(333) = 64,
 
     string fileName = "data1";
     string outputFileName = "result1";
     string line;
 
     ifstream dataFile;
     dataFile.open(fileName);
 
     // read # of test cases
     getline(dataFile, line);
     int numTests = stoi(line);
 
     // read all test inputs
     vector<TestInput> testInputs(numTests);
     for (int i = 0; i < numTests; i++) {
         getline(dataFile, line);
         testInputs[i] = TestInput(line);
     }
     dataFile.close();
 
     // print test inputs
     ofstream resultFile;
     resultFile.open(outputFileName, ofstream::out | ofstream::trunc);
     for (int i = 0; i < numTests; i++) {
         list<long long> result = seqNumbers(testInputs[i].k, testInputs[i].c);
         cout << "Case #" << i + 1 << ":"; 
         resultFile << "Case #" << i + 1 << ":";
         for (list<long long>::iterator it = result.begin(); it != result.end(); it++) {
             cout << " " << (*it);
             resultFile << " " << (*it);
         }
         cout << endl;
         resultFile << endl;
     }
     resultFile.close();
 
     return 0;
 }