#include <fstream>
 #include <iostream>
 #include <string>
 #include <vector>
 
 std::vector<unsigned long long> getList(unsigned int length, unsigned int complexity) {
 	std::vector<unsigned long long> result;
 	if(length == 1) {
 		result.push_back(1);
 	}
 	else if(complexity == 1) {
 		for(int i = 0; i < length; ++i) result.push_back(i + 1);
 	}
 	else {
 		unsigned long long blockLength = length;
 		for(int i = 0; i < complexity - 1; ++i) blockLength *= blockLength;
 		blockLength /= length;
 		for(int i = 0; i < length / 2; ++i){
 			result.push_back((2 * i) * blockLength + (2 * i + 1) + 1);
 		}
 		if(length % 2) result.push_back(length * blockLength);
 	}
 	return result;
 }
 
 int main(int argc, char const *argv[]) {
 	std::fstream inFile(argv[1], std::fstream::in);
 	std::fstream outFile("result", std::fstream::out);
 	int testSize;
 	inFile >> testSize;
 	for(int i = 0; i < testSize; ++i) {
 		outFile << "Case #" << (i+1) << ":";
 		int length = 0, complexity = 0, hire = 0;
 		inFile >> length >> complexity >> hire;
 		auto list = getList(length, complexity);
 		if(hire < list.size())
 			outFile << " IMPOSSIBLE";
 		else{
 			for(int i = 0; i < list.size(); ++i) outFile << ' ' << list[i];
 		}
 		outFile << std::endl;
 	}
 }
