#include <cstdio>
 
 unsigned long long pow(int base, int exponent)
 {
 	unsigned long long sum = 1;
 
 	while(exponent--) {
 		sum *= base;
 	}
 
 	return sum;
 }
 
 int main()
 {
 	int T;
 
 	scanf(" %d", &T);
 	for(int caseId = 1; caseId <= T; ++caseId) {
 		int K, C, S;
 		
 		scanf(" %d %d %d", &K, &C, &S);
 
 		printf("Case #%d:", caseId);
 		if(K - C + 1 > S) {
 			printf(" IMPOSSIBLE\n");
 			continue;
 		}
 
 		// one tile
 		if(K == 1) {
 			printf(" 1\n");
 			continue;
 		}
 
 		// origin sequence
 		if(C == 1) {
 			for(int i = 1; i <= K; ++i) {
 				printf(" %d", i);
 			}
 			printf("\n");
 			continue;
 		}
 
 		if(C == 2) {
 			for(int i = 2; i <= K; ++i) {
 				printf(" %d", i);
 			}
 			printf("\n");
 			continue;
 		}
 
 		// clean only one tile
 		unsigned long long offset = K * pow(K, C - 2);
 		if(C > K) {
 			C = K;
 		}
 
 		for(int i = C; i <= K; ++i) {
 			printf(" %llu", offset + i);
 		}
 		printf("\n");
 	}
 
 	return 0;
 }
