#include <stdio.h>
 #include <stdlib.h>
 #include <limits.h>
 
 #define MAX_C_TILE_NUM 1000000000000000000
 
 unsigned long long GetTileNum(int base, int exponent)
 {
     unsigned long long iResultNum = 1;
     int iIndex = 1;
     for (;iIndex <= exponent; iIndex ++)
     {
         if (iResultNum >= ((MAX_C_TILE_NUM)/base)) return MAX_C_TILE_NUM;
         iResultNum *=base;
     }
     return iResultNum;
 }
 
 void PrintAllOrigin(int originNum, FILE *OutFile)
 {
     if (OutFile == NULL) return;
     int iIndex = 1;
     for (;iIndex <= originNum; iIndex ++)
     {
         fprintf(OutFile, " %d", iIndex);
     }
 
     fprintf(OutFile, "\n");
 }
 
 void HandleItem(unsigned long long TotalItemNum, int originNum, int complexity, int maxClean, FILE *OutFile)
 {
     if (OutFile == NULL) return;
     if (originNum == maxClean)
     {
         if (complexity == 1)
         {
             PrintAllOrigin(originNum, OutFile);
             return;
         }
         fprintf(OutFile, " 1");
         int iIndex = 1;
         unsigned long long Interval = GetTileNum(originNum, complexity -1);
         for (; iIndex < maxClean; iIndex ++)
         {
             unsigned long long TargetIndex = 1 + iIndex * Interval;
             if (TargetIndex < TotalItemNum)
             {
                 fprintf(OutFile, " %I64u", TargetIndex);
             }
             else
             {
                 fprintf(OutFile, " %I64u", TotalItemNum);
                 break;
             }
         }
         fprintf(OutFile, "\n");
     }
     else if (maxClean < originNum)
     {
         if (complexity == 1)
         {
             fprintf(OutFile, " IMPOSSIBLE\n");
             return;
         }
 
         fprintf(OutFile, " 2");
         int iIndex = 1, iIndex2 = 0;
         unsigned long long Interval = GetTileNum(originNum, complexity -1);
         for (; iIndex2 < maxClean -1; iIndex2 ++, iIndex +=2)
         {
             unsigned long long TargetIndex =  2+ (iIndex2+1) * Interval;
             if (TargetIndex < TotalItemNum)
             {
                 fprintf(OutFile, " %I64u", TargetIndex);
             }
             else
             {
                 fprintf(OutFile, " %I64u", TotalItemNum);
                 break;
             }
         }
         fprintf(OutFile, "\n");
 
     }
 
 }
 
 
 int main()
 {
     int numberCase = 0, CaseIndex =0;
     FILE *InFile = fopen("testD.txt", "r");
     FILE *OutFile = fopen("testDr.txt", "w");
     if (InFile==NULL)
     {
         printf("File is not opened\n");
         perror("Error");
         return 0;
     }
     fscanf(InFile, "%d", &numberCase);
     for(CaseIndex= 0; CaseIndex < numberCase; CaseIndex++)
     {
         int OriginItemNum =0, Complexity = 0, MaxClean = 0;
         fscanf(InFile, "%d %d %d", &OriginItemNum, &Complexity, &MaxClean);
         fprintf(OutFile, "Case #%d:", CaseIndex +1);
         unsigned long long TotalNum = GetTileNum(OriginItemNum, Complexity);
         HandleItem(TotalNum, OriginItemNum,  Complexity, MaxClean, OutFile);
 
     }
     fclose(InFile);
     fclose(OutFile);
     return 0;
 }
