#include <iostream>
 #include <fstream>
 #include <vector>
 
 std::vector<long long> clean(int K, int C, int S);
 
 int main()
 {
     // In & out.
     std::ifstream in;
     std::ofstream out;
 
     // Open files.
     in.open("D-large.in");
     out.open("D-large.out");
 
     // Global variables.
     int T, K, C, S;
     in >> T;
     for(int t = 0; t < T; t ++)
     {
         in >> K >> C >> S;
         // In small dataset, S==K
         out << "Case #" << t + 1 << ": ";
         std::vector<long long> tiles = clean(K, C, S);
 
         //If the number of tiles need to clean is bigger than S.
         //std::cout << t + 1 << "size: " << tiles.size() << std::endl;
         if(tiles.size() > S || tiles.size() == 0)
         {
             out << "IMPOSSIBLE" << std::endl;
             continue;
         }
         for(std::vector<long long>::iterator iter = tiles.begin(); iter != tiles.end(); iter ++)
         {
             out << *iter << " ";
         }
         out << std::endl;
     }
 
     // Close files.
     out.close();
     in.close();
 
     return 0;
 }
 
 // Return final result.
 std::vector<long long> clean(int K, int C, int S)
 {
     std::vector<long long> tiles;
     // Special case: S == K
     if(S == K)
     {
         for(int i = 1; i <= K; i ++)
         {
             tiles.push_back(i);
         }
         return tiles;
     }
 
     // From below: S < K
     if(C == 1) // Impossible to find.
     {
         return tiles;
     }
 
     // From below: S < K and C > 1.
     // Only need to consider situations when only 1 G exists.
     long long group_count = 1;
     for(int i = 1; i <= C-1; i++)
     {
         group_count *= K;
     }
 
     for(long long i = 0; i + 2 < K; i +=2)
     {
         //std::cout << group_count*i + i + 2 << " ";
         tiles.push_back(group_count*i + i + 2);
     }
     if(group_count % 2 == 1)
     {
         //std::cout << group_count * K - 1 << " ";
         tiles.push_back(group_count * K - 1);
     }
 
     return tiles;
 
 }
