#include <iostream>
 #include <cstdio>
 #include <vector>
 #include <algorithm>
 #include <numeric>
 
 using namespace std;
 
 void show(vector<unsigned long long> &v) {
 	for (auto el : v) {
 		cout << el << " ";
 	}
 	cout << endl;
 }
 
 string convert(string base, int k, int c) {
 	string now = base;
 	string g_str(base.size(), 'G');
 	for (int i = 1; i < c; i++) {
 		string to;
 		for (auto c : now) {
 			to += c == 'L' ? base : g_str;
 		}
 		now = to;
 	}
 	return now;
 }
 
 void solve_small(int no, int k, int c) {
 	vector<unsigned long long> powers(c, 1);
 	for (int i = 1; i < c; i++) {
 		powers[i] = powers[i - 1] * k;
 	}
 
 	printf("Case #%d:", no);
 
 	for (int i = 0; i < k; i++) {
 		vector<unsigned long long> nums(c, i);
 		auto a = inner_product(powers.begin(), powers.end(), nums.begin(), 0ULL);
 		cout << " " << a + 1;
 	}
 	cout << endl;
 }
 
 void solve_large(int no, int k, int c, int s) {
 	vector<unsigned long long> powers(c, 1);
 	for (int i = 1; i < c; i++) {
 		powers[i] = powers[i - 1] * k;
 	}
 	reverse(powers.begin(), powers.end());
 
 	printf("Case #%d:", no);
 	if (k > c * s) {
 		cout << "IMPOSSIBLE" << endl;
 		return;
 	}
 	for (int i = 0; i < k; i += c) {
 		vector<unsigned long long> nums(c, 0);
 		for (int j = 0; j < c; j++) {
 			nums[j] = min(i + j, k - 1);
 		}
 		auto a = inner_product(powers.begin(), powers.end(), nums.begin(), 0ULL);
 		cout << " " << a + 1;
 	}
 	cout << endl;
 }
 
 int main() {
 	int t, k, c, s;
 	cin >> t;
 
 
 
 	for (int i = 1; i <= t; i++) {
 		cin >> k >> c >> s;
 
 /*
 		string l_str(k, 'L');
 		for (int j = 0; j < k; j++) {
 			string str = l_str;
 			str[j] = 'G';
 			cout << str << " " << convert(str, k, c) << endl;
 		}
 */
 
 		// solve_small(i, k, c);
 		solve_large(i, k, c, s);
 
 	}
 	return 0;
 }
