#include <stdio.h>
 #include <string.h>
 #include <stdlib.h>
 
 #define NDEBUG			0
 #include <assert.h>
 
 #define RES_BAD			1
 #define RES_OK			0
 
 #if NDEBUG
 #	define dbg_printf(...)	((void)0)
 #else
 #	define dbg_printf(...)	printf(__VA_ARGS__) /* variadic macro, C99 */
 #endif
 
 #define MAX_LEN			1024
 
 int solve(FILE *f, char *result)
 {
 	int scanned;
 	int r, c, w;
 	int x = 0;
 
 	scanned = fscanf(f, "%d %d %d", &r, &c, &w);
 	if (scanned != 3) {
 		printf("Parsing failed\n");
 		return RES_BAD;
 	}
 	dbg_printf("r: %d, c: %d, w: %d\n", r, c, w);
 
 	x += r * (c / w);
 
 	if (c % w == 0)
 		x += w - 1;
 	else
 		x += w;
 
 	sprintf(result, "%d", x);
 
 	return RES_OK;
 }
 
 int main(void)
 {
 	FILE *file_in, *file_out;
 	char result[MAX_LEN] = { 0 };
 	int cases, a_case;
 	int scanned;
 
 	file_in = fopen("in.txt", "r");
 	file_out = fopen("out.txt", "w");
 
 	if (!file_in || !file_out)
 	{
 		printf("Bad i/o file\n");
 		return RES_BAD;
 	}
 
 	scanned = fscanf(file_in, "%d", &cases);
 	if (scanned != 1) {
 		printf("Reading number of cases failed\n");
 		return RES_BAD;
 	} else {
 		printf("Solving %d cases... \n", cases);
 	}
 
 	for (a_case = 0; a_case < cases; a_case++)
 	{
 		if (solve(file_in, result) == RES_BAD) {
 			printf("Solving failed!\n");
 			return RES_BAD;
 		}
 		fprintf(file_out, "Case #%d: %s\n", a_case + 1, result);
 	}
 
 	fclose(file_in);
 	fclose(file_out);
 
 	printf("Done!\n");
 
 	return RES_OK;
 }
