#include <stdio.h>
 #include <string.h>
 #include <stdlib.h>
 
 void Erase(char buf[], char *str);
 int compare(const void *a, const void *b);
 
 int main(void)
 {
   int t;  // test case
   char s[20001];
   int arr_result[2000];
   char *ptr;
   int i, j, k;
 
   FILE *fin = fopen("A-large.in", "rt");
   if (fin == NULL) {
     return -1;
   }
   FILE *fout = fopen("output.txt", "wt");
   if (fout == NULL) {
     return -1;
   }
 
   fscanf(fin, "%d", &t);
   for (i = 1; i <= t; i++) {
     fscanf(fin, "%s", &s);
     
     k = 0;
     // erase even number
     for (j = 0; j < strlen(s); j++) {
       switch (s[j]) {
         case 'Z':
           arr_result[k++] = 0;
           Erase(s, "ZERO");
           break;
         case 'W':
           arr_result[k++] = 2;
           Erase(s, "TWO");
           break;
         case 'U':
           arr_result[k++] = 4;
           Erase(s, "FOUR");
           break;
         case 'X':
           arr_result[k++] = 6;
           Erase(s, "SIX");
           break;
         case 'G':
           arr_result[k++] = 8;
           Erase(s, "EIGHT");
           break;
       }
     }
 
     // erase odd number
     for (j = 0; j < strlen(s); j++) {
       switch (s[j]) {
         case 'O':
           arr_result[k++] = 1;
           Erase(s, "ONE");
           break;
         case 'R':
         case 'T':
           arr_result[k++] = 3;
           Erase(s, "THREE");
           break;
         case 'F':
           arr_result[k++] = 5;
           Erase(s, "FIVE");
           break;
         case 'S':
           arr_result[k++] = 7;
           Erase(s, "SEVEN");
           break;
       }
     }
 
     // erase 9(NINE)
     for (j = 0; j < strlen(s); j++) {
       if (s[j] != '_') {
         arr_result[k++] = 9;
         Erase(s, "NINE");
       }
     }
 
     // sort
     qsort(arr_result, k, sizeof(int), compare);
 
     // output
     fprintf(fout, "Case #%d: ", i);
     //printf("Case #%d: ", i);
     for (j = 0; j < k; j++) {
       fprintf(fout, "%d", arr_result[j]);
       //printf("%d", arr_result[j]);
     }
     fprintf(fout, "\n");
     //printf("\n");
     
   }
 
   fclose(fin);
   fclose(fout);
 
   return 0;
 }
 
 void Erase(char buf[], char *str) {
   int i;
   char *p;
   for (i = 0; i < strlen(str); i++) {
     p = strchr(buf, str[i]);
     *p = '_';
   }
 }
 
 int compare(const void *a, const void *b) {
   if (*(char *)a == *(char *)b) return 0;
   if (*(char *)a > *(char *)b) return 1;
   return -1;
 }