/*
  * round_1b.a
  *
  */
 
 #include <assert.h>
 #include <stdio.h>
 #include <string.h>
 
 struct digit_case
 {
 	char name[10];
 	char c;
 	unsigned n;
 };
 
 void count(char* S, struct digit_case* dc)
 {
 	dc->n = 0;
 	while (*S)
 	{
 		if ((*S) == dc->c)
 			++dc->n;
 
 		++S;
 	}
 }
 
 void touch_c(char* S, char c, unsigned n)
 {
 	while (n)
 	{
 		assert ((*S) != 0);
 
 		if ((*S) == c)
 		{
 			(*S) = 1;
 			--n;
 		}
 
 		++S;
 	}
 }
 
 void touch_s(char* S, char* s, unsigned n)
 {
 	while (*s)
 	{
 		touch_c(S, (*s), n);
 		++s;
 	}
 }
 
 void touch(char* S, struct digit_case* dc)
 {
 	touch_s(S, dc->name, dc->n);
 }
 
 unsigned f(char* S)
 {
 	unsigned i, j;	
 
 	struct digit_case dc_v[10] =
 	{
 		{ "ZERO",	'Z', 0 },
 		{ "SIX",	'X', 0 },
 		{ "EIGHT",	'G', 0 },
 		{ "TWO",	'W', 0 },
 		{ "FOUR",	'U', 0 },
 		{ "SEVEN",	'S', 0 },
 		{ "THREE",	'T', 0 },
 		{ "FIVE",	'F', 0 },
 		{ "NINE",	'I', 0 },
 		{ "ONE",	'O', 0 },
 	};
 
 	unsigned sort[10] = {0, 9, 3, 6, 4, 7, 1, 5, 2, 8};
 	
 	for (i = 0; i < 10; ++i)
 	{
 		count(S, &dc_v[i]);
 		touch(S, &dc_v[i]);
 	}
 
 	putchar(' ');
 
 	for (i = 0;  i < 10; ++i)
 		for (j = 0; j < dc_v[sort[i]].n; ++j)
 			putchar('0' + i);
 
 	putchar('\n');
 }
 
 int main(int argc, char* argv[])
 {
 	unsigned T, i;
 	char S[2001];
 
 	scanf("%u\n", &T);
 
 	for (i = 1; i <= T; ++i)
 	{
 		fgets(S, 2001, stdin);
 		printf("Case #%u:", i);
 		f(S);
 	}
 
 	return 0;
 }
