#include <iostream>
 #include <vector>
 #include <algorithm>
 #include <queue>
 
 class SegmentTree {
 
 public:
     SegmentTree() {
     }
 
 
     std::pair<int, int> get_k_th(int n, int k) {
         std::priority_queue<std::pair<int, int> > pq;
         int cnt = 0;
         int pow = 1;
         while(pow <= k) {
             cnt++;
             pow = pow << 1;
         }
         preorder(1, n, pq, 1, k);
         std::pair<int, int> top;
         for (int i = 1; i <= k; i++) {
             top = pq.top();
             pq.pop();
         }
         return top;
     }
 
     std::pair<long long, long long> get_stat(long long n, long long k) {
         return preorder_tweaked(1, n, k);
     }
 
 private:
 
     void preorder(int left, int right, std::priority_queue<std::pair<int, int>>& pq, int cnt, int k) {
         if (left > right || cnt > k) {
             return;
         }
         int mid = (left + right) >> 1;
         int ls = mid - left;
         int rs = right - mid;
         pq.push(std::pair<int, int>(std::min(ls, rs),std::max(ls, rs)));
         preorder(left, mid - 1, pq, cnt+1, k);
         preorder(mid+1, right, pq, cnt+1, k);
     }
 
     std::pair<long long, long long> preorder_tweaked(long long low, long long high, long long k) {
 
         long long pow = 1;
         long long cnt = 1;
         while ((pow<<1) <= k) {
             cnt++;
             pow = pow << 1;
         }
 
         long long mid = (low + high + 1) >>1;
         long long ls = mid - low;
         long long rs = high - mid;
         long long min = std::min(ls, rs);
         long long max = std::max(ls, rs);
         long long debug_low;
         long long debug_high;
         for (long i = 1; i <= cnt; i++) {
             if (low == high) {
                 mid = low;
             } else {
                 mid = (low+high+1)>> 1;
             }
             ls = mid - low;
             rs = high - mid;
             debug_low = low;
             debug_high = high;
             ls = std::max(ls, 0ll);
             rs = std::max(rs, 0ll);
             min = std::min(ls, rs);
             max = std::max(ls, rs);
             pow = pow >> 1;
             if ((pow & k)) {
                 low = mid+1;
             } else {
                 high = mid-1;
             }
         }
 //        std::cout << mid<<" " << debug_low<<" "<<ls <<" "<< rs<<" " << debug_high<<std::endl;
         return std::pair<long long, long long>(max, min);
 
 
     }
 
 
 private:
 
 };
 int main(int argc, char *argv[])
 {
 
     freopen("C-large.in", "r", stdin);
 //    freopen("input.txt", "r", stdin);
     freopen("output.txt", "w", stdout);
 
     int test_case_number;
     scanf("%d", &test_case_number);
 
     for (size_t test_case = 1; test_case <= test_case_number; test_case++) {
         long long n, k;
         scanf("%lld %lld", &n, &k);
 //        std::cout << n << k <<std::endl;
 
         SegmentTree tree;
 //        std::pair<int, int> ans = tree.get_k_th(n, k);
         std::pair<long long, long long> ans = tree.get_stat(n, k);
         printf("Case #%d: %lld %lld\n", test_case, ans.first, ans.second);
 #if 0
         std::vector<int> values(n+3, 0);
         values[1] = 1;
         values[n+2] = 1;
         std::vector<int> ls(n+3, 0);
         std::vector<int> rs(n+3, 0);
         int ans_ls = 0;
         int ans_rs = 0;
         for (int ind = 1; ind <= k; ind++)
         {
             for (size_t j = 2; j <= n+1; j++) {
                 if (values[j-1] == 1) {
                     ls[j] = 0;
                 } else {
                     ls[j]  = ls[j-1] + 1;
                 }
 
             }
             for (size_t j = n+1; 2 <= j; j--) {
                 if (values[j+1] == 1) {
                     rs[j] = 0;
                 } else {
                     rs[j]  = rs[j+1] + 1;
                 }
             }
 
             int max_id = -1;
             int max_ls = -1;
             int max_rs = -1;
 
             for (size_t j = n+1; 2 <= j  ; j--) {
                 int candidata_val_min = std::min(rs[j], ls[j]);
                 int candidata_val_max = std::max(rs[j], ls[j]);
                 if (values[j] == 1) {
                     continue;
                 }
                 if (max_rs < candidata_val_min ) {
                     max_id = j;
                     max_rs = candidata_val_min;
                     max_ls = candidata_val_max;
                     ans_rs = candidata_val_max;
                     ans_ls = candidata_val_min;
                     continue;
                 }
 
                 if (max_rs == candidata_val_min && max_ls < candidata_val_max) {
                     max_id = j;
                     max_rs = candidata_val_min;
                     max_ls = candidata_val_max;
                     ans_rs = candidata_val_max;
                     ans_ls = candidata_val_min;
                     continue;
                 }
 
                 if (max_rs == candidata_val_min && max_ls == candidata_val_max && j < max_id) {
                     max_id = j;
                     max_rs = candidata_val_min;
                     max_ls = candidata_val_max;
                     ans_rs = candidata_val_max;
                     ans_ls = candidata_val_min;
                     continue;
                 }
 
             }
 
 
             int next_id = max_id;
             values[next_id] = 1;
         }
         printf("Case #%d: %d %d\n", test_case, ans_rs, ans_ls);
 #endif
 
     }
 
     return 0;
 }
