#include <algorithm>
 #include <cmath>
 #include <map>
 #include <iostream>
 
 using namespace std;
 
 void fill_stalls(long n, long k);
 
 int main() {
     int t;
     long k, n; 
     cin >> t;
     
     for (int x = 1; x <= t; ++x) {     
         cin >> n >> k;
         cout << "Case #" << x << ": ";
         fill_stalls(n, k);
         cout << endl;
     }
         
     return 0;
 }
 
 void fill_stalls(long n, long k) {       
     
     map<long, long> sections;    
     sections.insert(make_pair(n, 1));
     
     long min_divisions = log2(k);   
     
     for (int i = 0; i < min_divisions; ++i) {
         map<long, long> new_sections;
         
         auto iter = sections.begin();
         while (iter != sections.end()) {                            
             
             if (iter->first > 1) {
                 long lefthalf = (iter->first - 1) / 2;
                 long righthalf = iter->first / 2;
                 
                 if (lefthalf != 0) {
                     auto result = new_sections.insert(make_pair(lefthalf, iter->second));
                     if (!result.second)
                         result.first->second += iter->second;
                 }
                 
                 if (righthalf != 0) {
                     auto result = new_sections.insert(make_pair(righthalf, iter->second));
                     if (!result.second)
                         result.first->second += iter->second;
                 }
             }
             
             ++iter;
         }
         
         sections = new_sections;
     }
     
     long stallsOccupied = exp2(min_divisions) - 1;
     long stallsTok = k - stallsOccupied; 
     
     auto iter = sections.end();
     while (iter != sections.begin()) {        
         --iter;
         if (iter->second - stallsTok >= 0) {
             long lefthalf = (iter->first - 1) / 2;
             long righthalf = iter->first / 2;
             cout << max(lefthalf, righthalf) << " " << min(lefthalf, righthalf);
             break;
         }
         stallsTok -= iter->second;
     }
 }
 
