#include <stdio.h>
 
 typedef unsigned long long int uint64_t;
 
 struct split_t {
 	uint64_t s;
 	uint64_t num;
 	uint64_t ls;
 	uint64_t rs;
 };
 
 void update(struct split_t *p) {
 	p->ls = (p->s) ? ((p->s - 1) / 2) : 0;
 	p->rs = (p->s) ? (p->s / 2) : 0;
 }
 
 void split(struct split_t *l, struct split_t *r) {
 	update(l);
 	update(r);
 	uint64_t a_num = l->num, b_num = r->num;
 	l->s = l->ls;
 	r->s = r->rs;
 	if (l->rs == l->ls)
 		l->num += a_num;
 	else
 		r->num += a_num;
 
 	if (r->ls == r->rs)
 		r->num += b_num;
 	else
 		l->num += b_num;
 //	printf("S: l: %llu %llu\t r: %llu %llu\n", l->s, l->num, r->s, r->num);
 }
 
 void solve(struct split_t *val, uint64_t k) {
 	update(val);
 	if (k == 1) return;
 
 	// Initialize the first two halves
 	struct split_t l, r;
 	l.s = val->ls;
 	l.num = 1;
 	r.s = val->rs;
 	r.num = 1;
 
 	// Starting from 2 parts
 //	printf("I: l: %llu %llu\t r: %llu %llu\n", l.s, l.num, r.s, r.num);
 	uint64_t i = 2;
 	while (i * 2 < k + 1) {
 		split(&l, &r);
 		i *= 2;
 	}
 	val->num = k - (i - 1);
 //	printf("F: l: %llu %llu\t r: %llu %llu\n", l.s, l.num, r.s, r.num);
 //	printf("%llu\n", val->num);
 	if (val->num <= r.num) {
 		update(&r);
 		val->ls = r.ls;
 		val->rs = r.rs;
 	} else {
 		update(&l);
 		val->ls = l.ls;
 		val->rs = l.rs;
 	}
 }
 
 int main(int argc, char *argv[]) {
 	int t;
 	scanf("%d", &t);
 	for (int i = 0; i < t; ++i) {
 		struct split_t val;
 		uint64_t k;
 		scanf("%llu %llu", &val.s, &k);
 		solve(&val, k);
 		printf("Case #%d: %llu %llu\n", i + 1, val.rs, val.ls);
 	}
 }