#include <iostream>
 #include <fstream>
 #include <vector>
 #include <string>
 #include <cmath>
 #include <climits>
 #include <sstream>
 #include <queue>
 #include <unordered_map>
 
 using ll = unsigned long long;
 using namespace std;
 
 
 pair<ll, ll> solve_test(ll stall_num, ll person_num)
 {
     ll level_num = log(person_num) / log(2);
     ll level_stall_num = 0;
     ll person_ass_num = 0;
 
     for (int i = 0; i < level_num; ++i) {
       person_ass_num += pow(2, i);
     }
     level_stall_num = stall_num - person_ass_num;
 
     ll upper_size = ceil(level_stall_num/pow(2, level_num));
     ll lower_size = level_stall_num/pow(2, level_num);
 
     double ratio = level_stall_num/pow(2, level_num);
     ll upper_size_num = (ratio - lower_size) * pow(2, level_num);
     ll in_level_person_num = person_num - person_ass_num;
 
     ll section_size = (in_level_person_num <= upper_size_num) ? upper_size : lower_size;
     ll pos = (section_size - 1)/2;
     pair<ll, ll> res;
 
     res.first = max(pos, section_size - 1 - pos);
     res.second = min(pos, section_size - 1 - pos);
     return res;
 }
 
 pair<ll, ll> solve_test(string &line)
 {
     istringstream ss(line);
     string val;
 
     getline(ss, val, ' ');
     ll stall_num = stol(val);
     getline(ss, val, ' ');
     ll person_num = stol(val);
 
     return solve_test(stall_num, person_num);
 }
 
 int main(int argc, char **argv)
 {
   string line;
   ifstream in_file(argv[1]);
 
   getline(in_file, line);
   int test_num = stoi(line);
 
   for (int i = 0; i < test_num; ++i) {
     getline(in_file, line);
     auto res = solve_test(line);
     cout << "Case #" << i + 1 << ": " << res.first << " " << res.second << endl;
   }
 }
