#include <iostream>
 #include <utility>
 #include <cmath>
 #include <algorithm>
 
 // forward declaration
 std::pair<unsigned long long, unsigned long long> calcSideStalls(unsigned long long numStalls, unsigned long long numPeople);
 std::pair<unsigned long long, unsigned long long> split(unsigned long long int i);
 std::pair<unsigned long long, unsigned long long> splitPeople(unsigned long long i);
 bool leftOrRight(long long numPeople);
 
 void bathroomstalls_problem()
 {
 	int numProblems = 0;
 	std::cin >> numProblems;
 
 	for (int i = 0; i < numProblems; i++) {
 		unsigned long long int numStalls;
 		std::cin >> numStalls;
 		unsigned long long int numPeople;
 		std::cin >> numPeople;
 
 		// call recursive algorithm
 		std::pair<unsigned long long, unsigned long long> solution = calcSideStalls(numStalls, numPeople);
 
 		// first - maximum, second - minimum
 		std::cout << "Case #" << i + 1 << ": " << std::max(solution.first, solution.second) << " " << std::min(solution.first, solution.second) << std::endl;
 	}
 }
 
 std::pair<unsigned long long, unsigned long long> calcSideStalls(unsigned long long numStalls, unsigned long long numPeople)
 {
 	if (numPeople == 1) {
 		return split(numStalls);
 	}
 
 	if (numPeople == numStalls)
 		return std::pair<unsigned long long, unsigned long long>(0, 0);
 
 	unsigned long long divStalls = 0;
 	unsigned long long divPeople = 0;
 	bool loc = leftOrRight(numPeople);	// find whether location will be in right or left
 	if (loc) {							// if its on the right
 		divStalls = split(numStalls).second;
 		divPeople = std::max(splitPeople(numPeople-1).first, splitPeople(numPeople-1).second);
 	}
 	else {								// else its on the left
 		divStalls = split(numStalls).first;
 		divPeople = std::max(splitPeople(numPeople-1).first, splitPeople(numPeople-1).second);
 	}
 
 	return calcSideStalls(divStalls, divPeople);
 }
 
 std::pair<unsigned long long int, unsigned long long int> split(unsigned long long int i)
 {
 	if (i == 1)								// if one
 		return std::pair<unsigned long long int, unsigned long long int>(0, 0);
 	else if (i % 2 == 0)					// if even
 		return std::pair<unsigned long long int, unsigned long long int>(i / 2 - 1, i / 2);
 	else {									// if odd
 		return std::pair<unsigned long long int, unsigned long long int>(i / 2, i / 2);
 	}
 }
 
 bool leftOrRight(long long numPeople)	// 0 left, 1 right
 {
 	long long people = numPeople;
 	unsigned long long height = 0;
 	while (people > 0) {
 		people = people - std::pow(2, height);
 		height++;
 	}
 
 	unsigned long long numElements = 1;
 	for (int i = 1; i < height; ++i) {
 		numElements *= 2;
 	}
 
 	unsigned long long border = 3;
 	for (int i = 2; i < height; ++i) {
 		border *= 2;
 	}
 
 	if ((numPeople & (numPeople-1)) == 0 || numPeople > border)	// change to divisible by a power of 2
 		return true;
 	else
 		return false;
 }
 
 std::pair<unsigned long long, unsigned long long> splitPeople(unsigned long long i)
 {
 	if (i % 2 == 0)							// if even
 		return std::pair<unsigned long long int, unsigned long long int>(i / 2, i / 2);
 	else
 		return std::pair<unsigned long long, unsigned long long>(i / 2 + 1, i / 2);
 }
 
 int main()
 {
 	bathroomstalls_problem();
 
 	std::cin.get();
 	std::cin.get();
 
 	return 0;
 }