#include <stdlib.h>
 #include <stdio.h>
 #include <string.h>
 #include <assert.h>
 
 typedef struct aval_distances {
   struct aval_distances *next;
   int dist;
 } *sorted_dists;
 
 sorted_dists New_SD(int dist)
 {
   sorted_dists out;
   out = (sorted_dists)(malloc(sizeof(struct aval_distances)));
   out->next = NULL;
   out->dist = dist;
   return out;
 }
 
 void Free_SD(sorted_dists sd)
 {
   if (sd) {
     Free_SD(sd->next);
     free(sd);
   }
 }
 
 //sort the list with as little work as possible
 sorted_dists Add_Dis(sorted_dists old, int big, int small)
 {
   sorted_dists ret;
   if (big <= 0)
     return old;
   if (old && old->dist > big) {
     old->next = Add_Dis(old->next, big, small);
     return old;
   }
   ret = New_SD(big);
   ret->next = Add_Dis(old, small, 0);
   return ret;
 }
 
 void Split_Distance(int src, int *big, int *small)
 {
   int mark;
   assert(src>0);
   mark = (src+1)/2;
   *big = src - mark;
   *small = mark-1;
 }
 
 int main ( int argc, char *argv[] ) 
 { 
   char line[255];
   FILE *in, *out;
   int trial, ntrials;
   int size, npeople, p;
   int large, small;
   sorted_dists sd=NULL, tmp=NULL;
 
   assert(argc > 2);
   in = fopen( argv[1], "r" );
   out = fopen( argv[2], "w" );
 
   fscanf(in, "%d", &ntrials);
   for (trial=1;trial<=ntrials;trial++) {
     fscanf(in, "%d %d", &size, &npeople);
     sd = New_SD(size);
     for(p=0;p<npeople-1;p++){
       assert(sd);
       tmp=sd; //largest open space
       sd = tmp->next;
       tmp->next = NULL;
       Split_Distance(tmp->dist, &large, &small);
       fprintf(stderr, "base=%d large=%d small=%d\n", tmp->dist, large, small);
       sd = Add_Dis(sd, large, small);
       Free_SD(tmp);
     }
     assert(sd);
     Split_Distance(sd->dist, &large, &small);
     fprintf(stderr, "base=%d large=%d small=%d\n", sd->dist, large, small);
     fprintf(out, "Case #%d: %d %d\n", trial, large, small);
     Free_SD(sd);
     sd = NULL;
   }
 }
