#include <iostream>
 #include <string>
 #include <vector>
 #include <sstream>
 #include <limits>
 #include <algorithm>
 using namespace std;
 
 // Number to String
 template <class T>
 inline std::string to_string (const T& t)
 {
     std::stringstream ss;
     ss << t;
     return ss.str();
 }
 
 
 
 typedef struct box
 {
 	unsigned long long left;
 	unsigned long long right;
 	long long diff;
 	unsigned long long sum;
 	bool alloc;
 	/*bool operator<( const box& val ) const { 
         return sum < val.sum; 
     }*/
 }box;
 
 //struct Xgreater
 //{
 //    bool operator()( const box& lx, const box& rx ) const {
 //        return lx.sum < rx.sum;
 //    }
 //};
 
 vector<box> v;
 vector<unsigned long long> vx;
 
 void fill(unsigned long long start, unsigned long long end)
 {
 	box b;
 	b.left = b.right = b.diff = b.sum = 0;
 	b.alloc = true;
 	v.push_back(b);
 	vx.push_back(start);
 	for(unsigned long long c = start+1; c < end+1; ++c)
 	{
 		b.left = c - 1;
 		b.right = end - c;
 		b.diff = b.right - b.left;
 		b.sum = b.right + b.left;
 		b.alloc = false;
 		v.push_back(b);
 	}
 	b.alloc = true;
 	b.left = b.right = b.diff = b.sum = 0;
 	v.push_back(b);
 	vx.push_back(end+1);	
 	return;
 }
 
 void check(unsigned long long end)
 {
 	unsigned long long k = 0;
 	unsigned long long q = 0;
 	
 	for(unsigned long long c = 0; c < end+1; ++c)
 	{
 		if(v[c].alloc) 
 		{
 			q = 0;
 			if(c) 
 			  k++;
 			continue;
 		}
 
 		// if(vx.size()> k && vx[k] > c)
 		{
 			v[c].left = c - vx[k] -1;
 		    v[c].right = vx[k+1] - c - 1;
 		    v[c].diff = v[c].right - v[c].left;
 			v[c].sum = v[c].right + v[c].left;
 		}		
 	}
 }
 
 #if 0
 box mark(unsigned long long end)
 {
 	long long min = std::numeric_limits<long long>::max();
 	long long max = 0;
 	unsigned long long idx = 0;
 	vector<box> temp;
 	// temp = v;
 	// std::sort( v.begin()+1, v.end()-1, Xgreater());
 	for(unsigned long long c = 1; c < end+1; ++c)
 	{
 		if(v[c].alloc) continue;
 
 		//if(abs(min) >= abs(v[c].diff) && max < v[c].sum) 
 		if(abs(min) > abs(v[c].diff))
 		 {			 
 			min = v[c].diff;
 			max = v[c].sum;
 			idx = c;			 
 		 }		
 	}
 	
 	v[idx].alloc = true;
 	vx.push_back(idx);
 	std::sort(vx.begin(), vx.end());
 	return v[idx];
 }
 #else
 box mark(unsigned long long end)
 {
 	long long min = std::numeric_limits<long long>::max();
 	unsigned long long idx = 0, extra = 0;
 	for(unsigned long long c = 1; c < end+1; ++c)
 	{
 		if(v[c].alloc) continue;
 		 if(abs(min) > abs(v[c].diff))
 		 {
 			 if(v[c].left || v[c].right)
 			 {
 				 min = v[c].diff;
 				 idx = c;
 			 }
 			 else
 			 {
 				 extra = c;
 			 }
 		 }
 	}
 	if(min == std::numeric_limits<long long>::max())
 		idx = extra;
 	v[idx].alloc = true;
 	vx.push_back(idx);
 	std::sort(vx.begin(), vx.end());
 	return v[idx];
 }
 #endif
 
 
 int main()
 {
 	freopen("Input.in", "rt", stdin);
 	freopen("Output.out", "wt", stdout);
 	int ntc = 0;
 	cin >> ntc;
 	
 	for(int tc = 0; tc < ntc; ++tc)
 	{
 		v.clear();
 		vx.clear();
 		unsigned long long toi = 0;
 		unsigned long long men = 0;
 		cin >> toi; 
 		cin >> men;
 		fill(0, toi);
 		box b;
 		
 		if(men >= toi)
 		{
 			b.right = b.left = 0;
 		}
 		else
 		
 		{
 			for(unsigned long long m = 0; m < men; ++m)
 			{
 				b = mark(toi);			
 				check(toi);
 			}
 	   }
 		
 		cout<<"Case #"<<tc+1<<": " <<b.right<<" "<<b.left<< endl;
 	}
 	return 0;
 }