#include<iostream>
 #include<cstdio>
 #include<cstring>
 #include<cstdlib>
 #include<cmath>
 #include<vector>
 #include<map>
 #include<algorithm>
 #include<stack>
 #include<queue>
 #include<list>
 
 using namespace std;
 
 int resMax = 0, resMin = 0;
 
 int checkStaleMate(int* arr, int length, int val) {
 	int count = 0;
 	for(int i = 0; i < length ; i++) {
 		if(arr[i] == val) {
 			count ++;
 		}
 	}
 	return count;
 }
 
 int getDiffLeft(int* arr, int length, int currentIndex) {
 	for(int i = currentIndex; i >= 0; i--) {
 		if(arr[i] == 1) {
 			return currentIndex - i - 1;
 		}
 	}
 	return -1;
 }
 
 int getDiffRight(int* arr, int length, int currentIndex) {
 	for(int i = currentIndex; i < length; i++) {
 		if(arr[i] == 1) {
 			return i - currentIndex - 1;
 		}
 	}
 	return -1;
 }
 
 int getStall(int* arr, int length, int value) {
 	for(int i = 1; i < length - 1; i++) {
 		if(arr[i] == value)
 			return i;
 	}
 	return -1;
 }
 
 int maximal(int* arr, int length) {
 	int max = 0;
 	for(int i = 0; i < length; i++) {
 		if(arr[i] > max) {
 			max = arr[i];
 		}
 	}
 	return max;
 }
 
 int getMin(int a, int b) {
 	return (a - b <= 0) ? a : b;
 }
 
 int getMax(int a, int b) {
 	return (a - b >= 0) ? a : b;
 }
 
 int getEmptySpotsLength(int* arr, int length) {
 	int spots = 0;
 	for(int i = 1; i < length - 1; i++) {
 		if(arr[i] == 0) {
 			spots++;
 		}
 	}
 	return spots;
 }
 
 int populateSet(int* arr, int length){
 	int min, max;
 	int l = getEmptySpotsLength(arr, length);
 	int minArr[l], maxArr[l];
 	int minIx[l], maxIx[l];
 
 	for(int i = 0; i < l; i++) {
 		minArr[i] = maxArr[i] = minIx[i] = maxIx[i] = 0;
 	}	
 
 	int j = 0;
 	int dLeft = 0;
 	int dRight = 0;
 
 	int occupyIx = 0;
 	
 	// Iterating over the stalls array
 	for(int i = 1; i < length - 1; i++) {
 		// Empty Stall
 		if(arr[i] == 0) {
 
 			dLeft = getDiffLeft(arr, length, i);
 			dRight = getDiffRight(arr, length, i);
 
 			min = getMin(dLeft, dRight);
 			minArr[j] = min;
 			minIx[j] = i;
 			max = getMax(dLeft, dRight);
 			maxArr[j] = max;
 			maxIx[j] = i;
 			j++;
 		}
 	}
 
 
 	// // Check count of max value in minArr[]
 	int count = checkStaleMate(minArr, l, maximal(minArr, l));
 
 	if(count > 1) {
 		int m = maximal(minArr, l);
 		for(int i = 0; i < l; i++) {
 			if(minArr[i] != m) {
 				maxArr[i] = -1;
 			}
 		}
 
 		int mm = maximal(maxArr, l);
 
 		if(checkStaleMate(maxArr, l, mm) > 1) {
 			for(int i = 0; i < l; i++) {
 				if(maxArr[i] == mm) {
 					occupyIx = maxIx[i];
 					return occupyIx;
 				}
 			}
 		} else {
 			int x = getStall(maxArr, l, mm);
 			occupyIx = maxIx[x];
 		}
 
 	} else {
 		int x = getStall(minArr, l, maximal(minArr, l));
 		occupyIx = minIx[x];
 	}
 
 	return occupyIx;
 }
 
 
 int main(){
     freopen("in","r",stdin);
     freopen("out","w",stdout);
     int T;
     cin>>T;
 
     for(int t=1; t<=T; t++){
         printf("Case #%d: ",t);
         
         long stalls;
         long people;
 
         cin>>stalls;
         cin>>people;
         
         int arr[stalls + 2];
         
         for(int i = 0; i <  stalls + 2; i++) {
         	arr[i] = 0;
         }
 
         arr[0] = arr[stalls + 1] = 1;
         
         int ocIx = 0;
 
         for(int i = 0; i < people; i++) {
         	ocIx = populateSet(arr, stalls + 2);
         	arr[ocIx] = 1;
         }
 
         int emptyLeft = 0, emptyRight = 0;
 
         for(int i = ocIx - 1; i >= 0; i--){
         	if(arr[i] == 1) {
         		break;
         	}
         	emptyLeft++;
         }
 
         for(int i = ocIx + 1; i < stalls + 1; i++) {
         	if(arr[i] == 1) {
         		break;
         	}
         	emptyRight++;
         }
         cout<<max(emptyLeft, emptyRight)<<" "<<min(emptyLeft, emptyRight)<<endl;
         
         // for(int i = 0; i <  stalls + 2; i++) {
         	// cout<<arr[i];
         // }
         // cout<<endl;
         // cout<<resMax<<" "<<resMin<<endl;
         
 
     }
 
 return 0;
 }
