#include <iostream>
 #include <utility>
 #include <vector>
 using namespace std;
 
 pair<long long, long long> solve(long long n, long long k) {
     vector<long long> occupied;
     
     // Initial State
     occupied.push_back(0);
     occupied.push_back(n + 1);
 
     // Repeat Operation Until K Is Inserted
     long long left;
     long long right;
 
     for(long long i = 0; i < k; i++) {
         // loop Through All The Gaps
         vector<long long>::iterator maxInitPos = occupied.begin();
         long long maxGap = 0;
         for (vector<long long>::iterator iter = occupied.begin(); iter+1 != occupied.end(); iter++) {
             if (*(iter+1) - *iter - 1 > maxGap) {
                 maxGap = *(iter+1) - *iter;
                 maxInitPos = iter;
             }
         }
 
         // If Final Person
         if (i == k -1) {
             left = *maxInitPos;
             right = *(maxInitPos+1);
         }
 
         occupied.insert(maxInitPos + 1, *maxInitPos + maxGap / 2);
     }
     return make_pair((right - left) / 2 - 1, (right - left + 1)/2 - 1);
 }
 
 int main() {
     int t;
     long long n;
     long long k;
 
     cin >> t;
 
     for (int i = 1; i <= t; i++) {
         cin >> n >> k;
         pair<long long, long long> ans = solve(n, k);
         cout << "Case #" << i << ": " << ans.second << " " << ans.first << endl;
     }
 
     return 0;
 }