#include <iostream>
 #include <sstream>
 #include <fstream>
 #include <bitset>
 #include <string>
 #include <vector>
 #include <algorithm>
 #include <unordered_map>
 #include <cmath>
 #include <map>
 
 using namespace std;
 
 struct Result
 {
 	unsigned long long leftmost = 0;
 	unsigned long long rightmost = 0;
 };
 
 Result getPositionInInterv(unsigned long long roomAvail)
 {
 	Result res;
 
 	res.leftmost = std::floor((float)roomAvail / 2.f);
 	res.rightmost = std::ceil((float)roomAvail / 2.f);
 
 	return res;
 }
 
 Result resolveBathingIssue(unsigned long long bathrooms, unsigned long long clients)
 {
 	if (clients > bathrooms / 2)
 	{
 		return Result();
 	}
 
 	unsigned long long roomAvail = bathrooms;
 	Result r;
 	int i = clients;
 	while(i > 1)
 	{
 		--roomAvail; // client consume one room
 		r = getPositionInInterv(roomAvail);
 		int nextClients = i - 1;
 		bool even = nextClients % 2 == 0;
 		bool roomEven = roomAvail % 2 == 0;
 		bool morePopulated = (roomEven && !even) || (!roomEven && even);
 
 		if (roomEven)
 		{
 			roomAvail = even ? r.rightmost : r.leftmost;
 		}
 		else
 		{
 			roomAvail = even ? r.leftmost : r.rightmost;
 		}
 
 		i = morePopulated ? std::floor((float)nextClients / 2.f) : std::ceil((float)nextClients / 2.f);
 	}
 
 	return getPositionInInterv(--roomAvail);
 }
 
 int main()
 {
 	ifstream inputFile("C-small-1-attempt1.in");
 	ofstream outputFile("output_2017.txt");
 
 	int testNumber = 0;
 
 	inputFile >> testNumber;
 
 	for (int i = 1; i <= testNumber; ++i)
 	{
 		outputFile << "Case #" << i << ": ";
 		unsigned long long bathRooms;
 		unsigned long long clients;
 
 		inputFile >> bathRooms;
 		inputFile >> clients;
 
 		auto res = resolveBathingIssue(bathRooms, clients);
 
 		outputFile << res.rightmost << " " << res.leftmost << endl;
 	}
 
 	return 0;
 }
