
 #include <stdio.h>
 #include <string.h>
 #include <stdlib.h>
 #include <math.h>
 
 #define UL unsigned long
 
 void LS(int n, int l, long* lOut, long* sOut) {
     UL L0, S0;
     L0 = n % 2;
     S0 = 1 - (n % 2);
 
     UL Sn2 = S0, 
        Sn1 = 2*L0 + S0,
        S = 2*Sn2 + Sn1, //S2
        L = Sn2; //L2
 
     if (l == 0) {
         *lOut = L0;
         *sOut = S0;
         return;
     }
     if (l == 1) {
         *lOut = S0;
         *sOut = Sn1;
         return;
     }
 
     if (l == 2) {
         *lOut = Sn1;
         *sOut = S;
         return;
     }
 
     for (int i = 2; i < l; ++i) {
         Sn1 = S;
         S = 2*Sn2 + S;
         Sn2 = Sn1;
     }
 
     *lOut = Sn1;
     *sOut = S;
 
     return;
 }
 
 void calculate(UL n, UL nth, UL* max_dist, UL* min_dist) {
     UL s;
     //printf("N: %lu NTH: %lu\n", n, nth);
     double l = floor(log(nth)/log(2));
     long b = pow(2, l);
     //printf("l: %f, b:%lu\n", l, b);
 
     long L, S;
     LS(n, l, &L, &S);
     //printf("L: %lu S: %lu\n", L, S);
 
     long r = n-b;
     long rnth = nth - b;
 
     if (L+S >= n) {
         *max_dist = 0;
         *min_dist = 0;
         return;
     }
 
     long p = L+S;
     long ps = (r)/p;
 
     //printf("p: %lu ps: %lu\n", p, ps);
     //printf("r: %lu rnth: %lu\n", r, rnth);
 
     if (ps % 2 == 0) {
         if (rnth < L) {
             *min_dist = ps/2;
             *max_dist = ps/2;
         } else {
             if (ps > 0) {
                 *min_dist = ps/2 - 1;
             } else {
                 *min_dist = 0;
             }
             *max_dist = ps/2;
         }
     } else {
         if (rnth < S) {
             *min_dist = ps/2;
             *max_dist = ps/2 + 1;
         } else {
             *min_dist = ps/2;
             *max_dist = ps/2;
         }
     }
 }
 
 int main(int argc, char** argv) {
     FILE* fp = fopen(argv[1], "r");
     if (!fp) {
         perror("open");
         return 1;
     }
 
     int num_cases = 0;
     if (1 != fscanf(fp, "%d\n", &num_cases)) {
         fprintf(stderr, "Invalid format (number of cases)\n");
         return 1;
     }
     
     for (int i = 0; i < num_cases; ++i) {
         UL num_stalls = 0, level = 0;
         UL max_dist = 0, min_dist = 0;
         if (2 != fscanf(fp, "%lu %lu\n", &num_stalls, &level)) {
             fprintf(stderr, "Invalid format (num_stalls level)\n");
             return 1;
         }
         calculate(num_stalls, level, &max_dist, &min_dist);
         printf("Case #%d: %lu %lu\n", i+1, max_dist, min_dist);
     }
 }