#include <stdio.h>
 #include <stdbool.h>
 #include <stdlib.h>
 #include <math.h>
 
 #define min(a,b) ((a) < (b) ? (a) : (b))
 #define max(a,b) ((a) > (b) ? (a) : (b))
 
 typedef struct {
     unsigned long left;
     unsigned long right;
 } dist;
 
 void Swap(dist* a, dist* b) {
     dist temp;
     temp.left = a->left;
     temp.right = a->right;
     a->left = b->left;
     a->right = b->right;
     b->left = temp.left;
     b->right = temp.right;
 }
 
 int Partition(dist* dists, int left, int right) {
     dist temp = dists[right];
     int i = left;
 
     for (int j = left; j <= right - 1; j++) {
         if (min(dists[j].left, dists[j].right) > min(temp.left, temp.right)) {
             Swap(&dists[i], &dists[j]);
             i++;
         }else if (min(dists[j].left, dists[j].right) == min(temp.left, temp.right)) {
             if (max(dists[j].left, dists[j].right) > max(temp.left, temp.right)) {
                 Swap(&dists[i], &dists[j]);
                 i++;
             }
         }
     }
 
     Swap(&dists[i], &dists[right]);
     return i;
 }
 
 dist FindPlace(dist* dists, int left, int right, int k) {
     if (k > 0 && k <= right - left + 1) {
         int pos = Partition(dists, left, right);
 
         if (pos - left == k - 1)
             return dists[pos];
 
         if (pos - left > k - 1)
             return FindPlace(dists, left, pos - 1, k);
 
         return FindPlace(dists, pos + 1, right, k - pos + left - 1);
     }
 
     dist bad = {-1, -1};
     return bad;
 }
 
 int main(int argc, char* argv[]) {
     int t;
     unsigned long n;
     unsigned long k;
     dist* dists = (dist *) malloc(524288 * sizeof(dist));
 
     if (!dists)
         exit(1);
 
     scanf("%d ", &t);
 
     for (int i = 0; i < t; i++) {
         scanf("%lu %lu", &n, &k);
 
         int level = floor(log2l((long double) k)) + 1;
         unsigned long u = 0;
 
         for (int j = 1; j < level; j++) {
             u += pow(2, j - 1);
         }
 
         unsigned long rem = k - u;
         unsigned long denom = pow(2, level);
         unsigned long denomLess = pow(2, level - 1);
 
         if (round((2.0 * n) / denom) - round(1.0 * n / denom) > 0) {
             dists[0].left = round(1.0 * n / denom) - 1;
             dists[0].right = round((2.0 * n) / denom) - round(1.0 * n / denom) - 1;
         } else {
             dists[0].left = 0;
             dists[0].right = 0;
         }
 
         if (round((2.0 * (denomLess - 1) + 1) * n / denom) - round((2.0 * (denomLess - 1))) > 0) {
             dists[denomLess - 1].left = round((2.0 * (denomLess - 1) + 1) * n / denom) - round((2.0 * (denomLess - 1)) * n / denom) - 1;
             dists[denomLess - 1].right = n - round((2.0 * (denomLess - 1) + 1) * n / denom);
         } else {
             dists[denomLess - 1].left = 0;
             dists[denomLess - 1].right = 0;
         }
 
         //printf("%lu %.2f\n", denom, 2.0 * n / denom);
         //printf("DIST: %lu, %lu : %.2f\n", dists[0].left, dists[0].right, round(1.0 * n / denom));
         //printf("DIST: %lu, %lu : %.2f\n", dists[denomLess - 1].left, dists[denomLess - 1].right, round((2.0 * (denomLess - 1) + 1) * n / denom));
 
         for (int j = 1; j < pow(2, level - 1) - 1; j++) {
             if (round(((2.0 * j + 1) * n) / denom) - round(((2.0 * j) * n) / denom) > 0 &&
                 round(((2.0 * j + 2) * n) / denom) - round(((2.0 * j + 1) * n) / denom) > 0) {
                 dists[j].left = round(((2.0 * j + 1) * n) / denom) - round(((2.0 * j) * n) / denom) - 1;
                 dists[j].right = round(((2.0 * j + 2) * n) / denom) - round(((2.0 * j + 1) * n) / denom) - 1;
             } else {
                 dists[j].left = 0;
                 dists[j].right = 0;
             }
             //printf("DIST: %lu, %lu\n", dists[0].left, dists[0].right);
         }
 
         dist res = FindPlace(dists, 0, pow(2, level - 1) - 1, rem);
 
         printf("Case #%d: %lu %lu\n", i + 1, res.left, res.right);
     }
 
     return 0;
 }
