#include <stdio.h>
 #include <limits.h>
 #include <stdlib.h>
 #include <string.h>
 #define MAX(a, b) (((a) > (b)) ? (a) : (b))
 #define MIN(a, b) (((a) < (b)) ? (a) : (b))
 
 typedef struct  s_stalls
 {
     int         left;
     int         right;
 }               t_stalls;
 
 t_stalls    *init_stalls(int *stalls, int num_stalls)
 {
     t_stalls    *data;
 
     data = (t_stalls*)malloc(sizeof(t_stalls) * num_stalls);
     for (int i = 0; i < num_stalls; i++)
     {
         data[i].left = 0;
         data[i].right = 0;
     }
     return (data);
 }
 
 int         find_optimal(int *stalls, int num_stalls, int *max, int *min)
 {
     t_stalls    *data;
     int         i;
     int         optimal;
     int         min_tmp;
     int         max_tmp;
 
     data = init_stalls(stalls, num_stalls);
     for (i = 1; i < num_stalls; i++)
         if (stalls[i] == 0 && stalls[i - 1] == 0)
             data[i].left = data[i - 1].left + 1;
     for (i = num_stalls - 2; i >= 0; i--)
         if (stalls[i + 1] == 0 && stalls[i] == 0)
             data[i].right = data[i + 1].right + 1;
     *min = 0;
     *max = 0;
     for (i = num_stalls - 2; i > 0; i--)
     {
         min_tmp = MIN(data[i].left, data[i].right);
         if (min_tmp > *min)
         {
             *min = min_tmp;
             *max = MAX(data[i].left, data[i].right);
             optimal = i;
         }
         else if (min_tmp == *min)
         {
             max_tmp = MAX(data[i].left, data[i].right);
             if (max_tmp >= *max)
             {
                 *max = max_tmp;
                 optimal = i;
             }
         }
     }
     free(data);
     return (optimal);
 }
 
 void        calculate(int *stalls, int num_stalls, int num_ppl, int *max, int *min)
 {
     int     index;
 
     while (num_ppl--)
     {
         index = find_optimal(stalls, num_stalls, max, min);
         stalls[index] = 1;
     }
 }
 
 int			main(void)
 {
 	int			num_test;
     int         num_stalls;
     int         num_ppl;
     int         max;
     int         min;
     int         *stalls;
 
 	scanf("%d", &num_test);
 	for (int i = 0; i < num_test; i++)
 	{
 		scanf("%d %d", &num_stalls, &num_ppl);
         stalls = (int*)malloc(sizeof(int) * (num_stalls + 2));
         memset(stalls, 0, sizeof(int) * (num_stalls + 2));
         stalls[0] = 1;
         stalls[num_stalls + 1] = 1;
         calculate(stalls, num_stalls + 2, num_ppl, &max, &min);
         free(stalls);
         printf("Case #%d: %d %d\n", i + 1, max, min);
 	}
 	return (0);
 }
