#include <iostream>
 #include <vector>
 #include <cassert>
 
 using namespace std;
 
 typedef long long ll;
 
 struct SegmentTree {
     int closest_pow(int n) {
         int ret = 1;
         while (ret < n) {
             ret *= 2;
         }
         return ret;
     }
     
     struct Node {
         int left;
         int left_inner;
         int right;
         int right_inner;
         
         Node(int n) : left(-1), left_inner(-1), right(n), right_inner(n) {}
         Node(int left, int right) : left(left), left_inner(left), right(right), right_inner(right) {}
     };
     
     int n;
     vector<Node> tree;
     
     SegmentTree(int n) : n(n), tree(closest_pow(2 * n), Node(n)) {
         init(0, 0, n);
     }
     
     void init(int n, int l, int r) {
         tree[n].left_inner = l - 1;
         tree[n].right_inner = r;
         
         if (l + 1 == r) return;
         
         int middle = (l + r) / 2;
         init(2 * n + 1, l, middle);
         init(2 * n + 2, middle, r);
     }
     
     Node func(const Node &left, const Node right) {
         int inner_size = right.left - left.right - 1;
         int left_size = left.right_inner - left.left_inner - 1;
         int right_size = right.right_inner - right.left_inner - 1;
         
         Node ret(left.left, right.right);
         
         if (inner_size >= left_size && inner_size >= right_size) {
             ret.left_inner = left.right;
             ret.right_inner = right.left;
         } else if (left_size >= right_size) {
             ret.left_inner = left.left_inner;
             ret.right_inner = left.right_inner;
         } else {
             ret.left_inner = right.left_inner;
             ret.right_inner = right.right_inner;
         }
         
         return ret;
     }
     
     pair<int, int> get() {
         return {tree[0].left_inner, tree[0].right_inner};
     }
     
     void take(int n, int l, int r, int pos) {
         if (l > pos || r <= pos) return;
         if (l + 1 == r) {
             tree[n] = Node(l, l);
             return;
         }
         
         int middle = (l + r) / 2;
         take(2 * n + 1, l, middle, pos);
         take(2 * n + 2, middle, r, pos);
         
         tree[n] = func(tree[2 * n + 1], tree[2 * n + 2]);
     }
 };
 
 pair<int, int> solve(int n, int k) {
     SegmentTree bath(n);
     int last_min, last_max;
     
     for (int i = 0; i != k; ++i) {
         pair<int, int> segment = bath.get();
         assert(segment.second - segment.first > 1);
         
         int pos = (segment.second + segment.first) / 2;
         last_min = pos - segment.first - 1;
         last_max = segment.second - pos - 1;
         
         bath.take(0, 0, n, pos);
     }
     
     return {last_max, last_min};
 }
 
 
 int main() {
     int tests;
     cin >> tests;
     
     for (int test = 0; test != tests; ++test) {
         int n, k;
         cin>> n >> k;
         auto res = solve(n, k);
         cout << "Case #" << test + 1 << ": " << res.first << ' ' << res.second << '\n';
     }
     
     return 0;
 }