#include <ctime>
 #include <climits>
 #include <cstdlib>
 #include <iostream>
 #include <string>
 #include <algorithm>
 #include <cmath>
 #include <cstdio>
 #include <cstring>
 #include <vector>
 #include <bitset>
 #include <utility>
 #include <queue>
 #include <list>
 #include <iomanip>
 #include <set>
 
 #define PI 3.14159265
 #define INF LLONG_MAX
 #define MAXN 1004
 
 
 using namespace std;
 
 long long n, k, res, l, r;
 vector<long long> dl,dr, dists, max_dists;
 bitset<MAXN> occupied;
 
 void read_input()
 {
   cin >> n >> k;
   dl.resize(n+3);
   dr.resize(n+3);
   dists.resize(n+3);
   max_dists.resize(n+3);
 }
 
 void print_output(int tc)
 {
   cout << "Case #" << tc << ": " << max(l,r) << " " << min(l,r) << endl;
 }
 
 void initial_dists()
 {
   dists[0] = -1;
   dists[n+1] = -1;
   dr[n+1] = -1;
   dr[0] = -1;
   dl[n+1] = -1;
   dl[0] = -1;
   occupied.set(0);
   occupied.set(n+1);
   max_dists[0] = -1;
   max_dists[n+1] = -1;
   for (int i = 0; i < n; ++i)
   {
     dl[i+1] = dl[i] + 1;
     dr[n-i] = dr[n-i+1] + 1;
   }
   for (int i = 0; i < n; ++i)
   {
     dists[i+1] = min(dl[i+1], dr[i+1]);
     max_dists[i+1] = max(dl[i+1], dr[i+1]);
   }
   occupied.reset();
   occupied.set(0);
   occupied.set(n+1);
 }
 
 void update_dists(int pos)
 {
   dl[pos] = -1;
   dr[pos] = -1;
   dists[pos] = -1;
   for (int i = 0; i < n; ++i)
     if (dl[i+1] != -1) dl[i+1] = dl[i] + 1;
   for (int i = n; i > 0; --i)
     if (dr[i] != -1) dr[i] = dr[i+1] + 1;
   for (int i = 0; i < n; ++i)
   {
     dists[i] = min(dl[i], dr[i]);
     if ((dl[i] != -1) && (dr[i] != -1))
       max_dists[i] = max(dl[i], dr[i]);
     else
        max_dists[i] = -1;
   }
 }
 
 int add_one_peasant()
 {
   int minpos = 0;
   for (int i = 0; i < n+1; ++i)
     if ((dists[i] > dists[minpos]) ||
        ((dists[i] == dists[minpos]) && (max_dists[i]) > max_dists[minpos]))
          minpos = i;
   occupied.set(minpos);
   update_dists(minpos);
   return minpos;
 }
 
 long long get_left(long long pos)
 {
   long long res = 0;
   pos--;
   while ((!occupied.test(pos)) && (pos > 0))
   {
     pos--;
     res++;
   }
   return res;
 }
 
 long long get_right(long long pos)
 {
   long long res = 0;
   pos++;
   while ((!occupied.test(pos)) && (pos < n+1))
   {
     pos++;
     res++;
   }
   return res;
 }
 
 void solve()
 {
   initial_dists();
   for (int i = 0; i < k; ++i)
     res = add_one_peasant();
   l = get_left(res);
   r = get_right(res);
 }
 
 
 int main(int argc, const char *argv[])
 {
   ios::sync_with_stdio(false);
   cin.tie(NULL);
   int t;
   cin >> t;
   for (int i = 0; i < t; ++i)
   {
     read_input();
     solve();
     print_output(i+1);
   }
   return 0;
 }
 
