#include <iostream>
 
 using namespace std;
 
 template<typename IS>
 int get_num_cases (IS &is)
 {
   string tmp;
   int num_cases;
   is >> num_cases;
   getline (is, tmp);
   return num_cases;
 }
 
 template<typename OS>
 void print_case (OS &os, int t, int value)
 {
   os << "Case #" << t << ": " << value << endl;
 }
 
 /*
      a
    *****
   *     *
 b *     *
   *     *
    *****
  */
 int calc_enclosed (int a, int b)
 {
   return 2*a+2*b+a*b;
 }
 
 template<typename IS, typename OS>
 void solve_case (IS &is, OS &os, int t)
 {
 
   string tmp;
 
   // Get case data
   int n, m, k;
   is >> n >> m >> k;
   getline (is, tmp);
 
   // Basic checks
   if (n==1 || m==1) {
     print_case (os, t, k);
     return;
   }
   if (n==2 || m == 2) {
     print_case (os, t, k);
     return;
   }
   if (k < 5) {
     print_case (os, t, k);
     return;
   }
 
   // Brute force!
   int min_stones = k;
   for (int a=1; a<n; ++a) {
     for (int b=1; b<m; ++b) {
       int res = calc_enclosed (a, b);
       int used_stones = 2*a+2*b;
       if (res >= k && used_stones < min_stones) {
         min_stones = used_stones;
       }
     }
   }
   print_case (os, t, min_stones);
 }
 
 int main()
 {
   const int t = get_num_cases (cin);
   for (int i=0; i<t; ++i) {
     solve_case (cin, cout, i+1);
   }
   return 0;
 }
