#include <iostream>
 #include <fstream>
 #include <cstdio>
 #include <vector>
 #include <string>
 #include <map>
 #include <list>
 #include <algorithm>
 
 using std::cin;
 using std::cout;
 using std::ifstream;
 using std::ofstream;
 using std::vector;
 using std::string;
 using std::map;
 
 const int kModulus = 1000000007;
 
 struct TrieVertex {
     int parent;
     bool leaf;
     bool forbidden;
     char symbol;
     int link;
     int fast_link;
 
     map<char, int> go;
     map<char, int> next;
 
     TrieVertex(int parent, char symbol) :
         parent(parent),
         symbol(symbol),
         leaf(false),
         forbidden(false),
         link(-1),
         fast_link(-1) {}
 };
 
 class Trie {
 public:
     explicit Trie(int _alphabet_size) :
         alphabet_size(_alphabet_size) {
         trie_vertices.reserve(1200);
         flag_forbidden.resize(1200);
         TrieVertex root(0, '&');
         trie_vertices.push_back(root);
     }
 
     void BuildLinks () {
         for (int ind = 0; ind < trie_vertices.size(); ++ind) {
             for (char jnd = 0; jnd < alphabet_size; ++jnd) {
                 Go(ind, jnd + 'a');
             }
         GetFastLink(ind);
         }
     }
 
     void AddString(const string& str) {
         int position = 0;
         for (int ind = 0; ind < str.length(); ++ind) {
             char sym = str[ind];
             if (trie_vertices[position].next.find(sym) != trie_vertices[position].next.end()) {
                 position = trie_vertices[position].next[sym];
             } else {
                 trie_vertices.push_back(TrieVertex(position, sym));
                 trie_vertices[position].next[sym] = trie_vertices.size() - 1;
                 position = trie_vertices[position].next[sym];
             }
         }
 
         trie_vertices[position].leaf = true;
         flag_forbidden[position] = 1;
     }
 
     bool IsStringInTrie (const string& str) {
         int len = str.length();
         int position = 0;
         for (int ind = 0; ind < len; ++ind) {
             char sym = str[ind];
             if (trie_vertices[position].next.find(sym) == trie_vertices[position].next.end()) {
                 return false;
             } else {
                 position = trie_vertices[position].next[sym];
             }
         }
         return true;
     }
 
     int CalculateNumberOfStrings (int max_length) {
         main_table.resize(max_length + 1);
         for (int ind = 0; ind < main_table.size(); ++ind) {
             main_table[ind].resize(trie_vertices.size());
         }
         for (int ind = 0; ind < trie_vertices.size(); ++ind) {
             main_table[0][ind] = 1;
         }
         for (int depth = 1; depth < main_table.size(); ++depth) {
             for (int vertex = 0; vertex < trie_vertices.size(); ++vertex) {
                 for (auto it = trie_vertices[vertex].go.begin();
                      it != trie_vertices[vertex].go.end(); ++it) {
                     int uertex = it->second;
                     if (flag_forbidden[uertex] == 0) {
                          main_table[depth][vertex] += main_table[depth - 1][uertex];
                          main_table[depth][vertex] %= kModulus;
                     }
                 }
             }
         }
         return main_table[max_length][0];
     }
 
 private:
     vector<TrieVertex> trie_vertices;
     vector<int> flag_forbidden;
     vector<vector<int> > main_table;
     int alphabet_size;
 
     int GetLink(int vertex) {
       if (trie_vertices[vertex].link == -1) {
         if (vertex == 0 || trie_vertices[vertex].parent == 0) {
           trie_vertices[vertex].link = 0;
         } else {
           trie_vertices[vertex].link =
               Go(GetLink(trie_vertices[vertex].parent), trie_vertices[vertex].symbol);
         }
       }
 
       return trie_vertices[vertex].link;
     }
 
     int Go(int vertex, char symbol) {
       if (trie_vertices[vertex].go.find(symbol) == trie_vertices[vertex].go.end()) {
         if (trie_vertices[vertex].next.find(symbol) != trie_vertices[vertex].next.end()) {
           trie_vertices[vertex].go[symbol] = trie_vertices[vertex].next[symbol];
         } else {
           if (vertex == 0)
             trie_vertices[vertex].go[symbol] = 0;
           else
             trie_vertices[vertex].go[symbol] = Go(GetLink(vertex), symbol);
          }
       }
 
         return trie_vertices[vertex].go[symbol];
     }
 
     int GetFastLink (int vertex) {
         if (trie_vertices[vertex].fast_link == -1) {
             int link = GetLink(vertex);
             if (link == 0) {
                 trie_vertices[vertex].fast_link = 0;
             } else {
                 if (trie_vertices[link].leaf == true) {
                     trie_vertices[vertex].fast_link = link;
                 } else {
                     trie_vertices[vertex].fast_link = GetFastLink(link);
                 }
             }
         }
         if (trie_vertices[vertex].fast_link != 0) {
             flag_forbidden[vertex] = 1;
         }
         return trie_vertices[vertex].fast_link;
     }
 };
 
 int main() {
     std::ios_base::sync_with_stdio(false);
     std::cin.tie(nullptr);
     int length;
     int string_number;
     int alphabet_size;
     cin >> length >> string_number >> alphabet_size;
     Trie trie(alphabet_size);
     for (int ind = 0; ind < string_number; ++ind) {
         string sstring;
         cin >> sstring;
         trie.AddString(sstring);
     }
     trie.BuildLinks();
     int ans = trie.CalculateNumberOfStrings(length);
     cout << ans <<"\n";
     return 0;
 }
