/*
  * qualification.d
  *
  */
 
 #include <assert.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <stdbool.h>
 
 enum winner
 {
 	RICHARD,
 	GABRIEL
 };
 
 const char* winner_s(enum winner w)
 {
 	switch (w)
 	{
 		case RICHARD: return "RICHARD";
 		case GABRIEL: return "GABRIEL";
 	}
 	assert (false);
 }
 
 struct test_case
 {
 	unsigned X, R, C;
 	enum winner y;
 };
 
 #define X tc->X
 #define R tc->R
 #define C tc->C
 #define y tc->y
 
 void read_test_case(struct test_case* tc)
 {
 	scanf(" %u %u %u ", &X, &R, &C);
 }
 
 void write_test_case(unsigned x, struct test_case* tc)
 {
 	printf("Case #%u: %s\n", x, winner_s(y));
 }
 
 #define min(a, b) ((a) < (b) ? (a) : (b))
 #define max(a, b) ((a) > (b) ? (a) : (b))
 
 void run_test_case(struct test_case* tc)
 {
 	y = GABRIEL;
 
 	unsigned min, max;
 
 	min = min(R, C);
 	max = max(R, C);
 
 	if (7 <= X)
 		y = RICHARD;
 
 	else if (max < X)
 		y = RICHARD;
 
 	else if ((max * min) % X)
 		y = RICHARD;
 
 	else if (2*min < X)
 		y = RICHARD;
 
 	else if (2*min == X)
 	{
 		unsigned i, h;
 
 		for (i = 0; i < min+1; ++i)
 		{
 			unsigned a1, a2;
 
 			bool b = true;
 
 			for (h = 0; h <= max-min; ++h)
 			{
 				a1 = h * min;
 				a1 += i * (min - 1);
 				a2 = max * min - X - a1;
 				b = b && ((a1 % X) || (a2 % X));
 			}
 
 			if (b)
 			{
 				y = RICHARD;
 				break;
 			}
 		}
 	}
 }
 
 void free_test_case(struct test_case* tc)
 {
 }
 
 #undef y
 #undef C
 #undef R
 #undef X
 
 int main(int argc, char* argv[])
 {
 	unsigned T, x;
 
 	scanf("%u", &T);
 
 	for (x = 1; x <= T; ++x)
 	{
 		struct test_case tc;
 		read_test_case(&tc);
 		run_test_case(&tc);
 		write_test_case(x, &tc);
 		free_test_case(&tc);
 	}
 }
