#include <cstdio>
 #include <iostream>
 
 /*
  * Files are assigned to stdin and stdout,
  * which allows for console level interaction.
  * Great for debugging.
  */
 
 int main(int argc, char* argv[]) {
     //variables
     int T; // cases     T= 64 or 1 ≤ T ≤ 100
     int X; //X-omino    1 ≤ X ≤ 4 or 1 ≤ X ≤ 20
     int R; //rows       1 ≤ R ≤ 4 or 1 ≤ R ≤ 20
     int C; //columns    1 ≤ C ≤ 4 or 1 ≤ C ≤ 20
     bool richardWins;
 
     //selecting and opening files
     if (argc > 3 || argc == 1) {
         std::cout << "Usage is <inputFile> [<outputFile>]\n";
         return 1;
     }
 
     freopen(argv[1], "r", stdin);
 
     if (argc == 3) {
         freopen(argv[2], "w", stdout);
     } else {
         freopen("d.out", "w", stdout);
     }
 
     //Start getting input
     std::cin >> T;
 
     for (int countT = 1; countT <= T; countT++) {
         //handle input
         richardWins = false;
         std::cin >> X;
         std::cin >> R;
         std::cin >> C;
 
         //process data
         if (!richardWins) {
             richardWins |= X >= 8; //X-omino can be hollow
         }
 
         if (!richardWins) {
             richardWins |= (X > R) && (X > C); //piece wider than board
         }
 
         if (!richardWins) {
             richardWins |= ((R * C) % X) != 0; //board not divisible by X
         }
 
         if (!richardWins) {
             richardWins |= (X >= 4) && (X > ((C - 1)+(R - 1))); //X-omino can have two voids and board limits placement to edge
         }
 
         //handle output
         std::cout << "Case #" << (countT) << ": " << (richardWins ? "RICHARD" : "GABRIEL") << "\n";
     }
 
 }