#include <algorithm>
 #include <cmath>
 #include <numeric>  // std::accumulate
 #include <cstdlib>  // std::atoi
 #include <iostream> // std::cout
 #include <fstream>
 #include <stdlib.h>
 #include <string>
 #include <vector>
 using namespace std;
 
 const string filename = "D-small-attempt2";
 
 const string inputfile = filename + ".in";
 const string outputfile = filename + ".out";
 
 // From Gabriel's POV
 const string WON = "GABRIEL";
 const string LOST = "RICHARD";
 
 bool solve(int type, int width, int height)
 {
     // Not enough grid space
     int grid_count = width * height;
     if (grid_count % type != 0)
         throw logic_error("Not enough grid space");
 
     // A 7+ polyomino can have holes - Hole possible
     if (type >= 7)
         throw logic_error("Possible hole");
 
     // Only one perfect fit
     // Note: 1 & 2 polyominos only have one piece
     if (type != 1 && type != 2 &&
         type == grid_count)
         throw logic_error("Only one perfect fit");
 
     // Bound checking
     int max = floor((float)type / 2.0f);
     int min = ceil((float)type / 2.0f);
 
     // Creation of hole
     if (type > 4 && (width <= min || height <= min))
         throw logic_error("Possible hole with 5+ polyomino");
 
     // Grid not large enough
     if (width < max || height < max)
         throw logic_error("Grid not large enough");
 
     return true;
 }
 
 int main()
 {
     ifstream input;
     ofstream output;
 
     input.open(inputfile, ifstream::in);
 
     if (!input.is_open())
     {
         cerr << "file not found!\n";
         return -1;
     }
 
     output.open(outputfile, ofstream::trunc);
 
     int cases;
 
     input >> cases;
     cout << "Total cases: " << cases << endl << endl;
 
     for (int i = 0; i < cases; i++)
     {
         int type, width, height;
 
         // Read
         input >> type >> width >> height;
         cout << type << "-omino in (" << width << "x" << height << ")" << endl;
 
         // Output solutions to file
         try {
             solve(type, width, height);
             output << "Case #" << i + 1 << ": " << WON << endl;
             cout   << "Case #" << i + 1 << ": " << WON << endl << endl;
         } catch (const logic_error &e) {
             output << "Case #" << i + 1 << ": " << LOST << endl;
             cout   << "Case #" << i + 1 << ": " << LOST << " - " << e.what() << endl << endl;
         }
     }
 
     input.close();
     output.close();
 }
 
