#include <algorithm>
 #include <bitset>
 #include <fstream>
 #include <iostream>
 #include <iterator>
 #include <cmath>
 #include <sstream>
 #include <vector>
 using namespace std;
 
 int main(int argc, char** argv)
 {
     if (argc != 3)
     {
         cerr << "Invalid commandline parameters" << endl;
         return -1;
     }
 
     fstream input(argv[1], fstream::in);
     fstream output(argv[2], fstream::out | fstream::trunc);
 
     int numTestCases;
     input >> numTestCases;
 
     for (int i = 0; i < numTestCases; i++)
     {
         int X, R, C;
 
         input >> X >> R >> C;
 
         if ((R * C) % X != 0) {
             output << "Case #" << (i + 1) << ": " << "RICHARD" << endl;
         } else if (X >= 7 || X >= 5) {
             output << "Case #" << (i + 1) << ": " << "RICHARD" << endl;
         } else if (X >= 2 * R + 1 || X >= 2 * C + 1) {
             output << "Case #" << (i + 1) << ": " << "RICHARD" << endl;
         } else {
             output << "Case #" << (i + 1) << ": " << "GABRIEL" << endl;
         }
     }
 }