/*
  */
 #include <algorithm>
 #include <iostream>
 #include <cassert>
 #include <cstdlib>
 #include <cstring>
 #include <vector>
 #include <queue>
 #include <cstdio>
 #include <cctype>
 #define BIT(k) (1ULL<<(k))
 #define MASK(k) (BIT(k)-1ULL)
 #define vc(x,y) (0<=(x)&&(x)<m&&0<=(y)&&(y)<n)
 using namespace std;
 #define N 4
 
 int m,n,K,seen[N][N],yes,board[N][N],visited[BIT(N*N)];
 char bts[BIT(16)];
 vector<unsigned int> e,moves;
 bool in_class[BIT(N*N)],connected[BIT(N*N)];
 
 unsigned int 
 b2int( const vector<pair<int,int> > &v ) {
 	unsigned int u = 0,i,j,k;
 	for ( i = 0; i < K; ++i ) 
 		j = v[i].first, k = v[i].second, u |= BIT(j*n+k);
 	assert( bts[u] == K );
 	return u;
 }
 
 int dfs( int x, int y ) {
 	int nx,ny,r = 0;
 	if ( seen[x][y] == yes ) return r;
 	assert( board[x][y] );
 	for ( seen[x][y]=yes, ++r, nx = x-1; nx <= x+1; ++nx )
 		for ( ny = y-1; ny <= y+1; ++ny )
 			if ( vc(nx,ny) && board[nx][ny] && seen[nx][ny] != yes )
 				if ( (!(nx-x) || !(ny-y)) && ((nx-x) || (ny-y)) )
 					r += dfs(nx,ny);
 	return r;
 }
 
 void shift( vector<pair<int,int> > &v ) {
 	int i,xx=(1<<29),yy=(1<<29);
 	for ( i = 0; i < K; ++i ) {
 		if ( v[i].first < xx  ) xx = v[i].first;
 		if ( v[i].second < yy ) yy = v[i].second;
 	}
 	for ( i = 0; i < K; ++i )
 		v[i].first -= xx, v[i].second -= yy;
 }
 
 void rotate( vector<pair<int,int> > &v ) {
 	int i,xx,yy;
 	for ( i = 0; i < K; ++i ) {
 		xx = v[i].first, yy = v[i].second;
 		v[i].first = -yy, v[i].second = xx;
 	}
 	shift(v);
 }
 
 void reflect_x( vector<pair<int,int> > &v ) {
 	for ( int i = 0; i < K; ++i ) 
 		v[i].second = n-v[i].second;
 	shift(v);
 }
 
 void reflect_y( vector<pair<int,int> > &v ) {
 	for ( int i = 0; i < K; ++i ) 
 		v[i].first = n-v[i].first;
 	shift(v);
 }
 
 void int2vec( unsigned int u, vector<pair<int,int> > &vec ) {
 	int i,k = 0;
 	assert( bts[u] == K );
 	for ( i = 0; i < n*n; ++i ) {
 		if ( !((u>>i)&1) ) continue ;
 		vec[k++] = make_pair(i/n,i%n);
 	}
 	shift(vec);
 }
 
 unsigned int to_origin( unsigned int src ) {
 	vector<pair<int,int> > v(N);
 	assert( K == bts[src] );
 	int2vec(src,v);
 	shift(v);
 	return b2int(v);
 }
 
 void
 gen_equiv_class( const unsigned int src, vector<unsigned int> &e ) {
 	unsigned int u,v,w,i,j,k;
 	queue<unsigned int> q;
 	vector<pair<int,int> > vec(N),o(N);
 
 	memset(in_class,0,sizeof in_class);
 	assert( bts[src] == K );
 	for ( u = to_origin(src), e.clear(), q.push(u), visited[u] = ++yes; !q.empty();) {
 		u = q.front();
 		assert( bts[u] == K );
 		in_class[to_origin(u)] = true, q.pop(), e.push_back(u);
 		int2vec(u,vec);
 		for ( i = 0; i < K; ++i ) o[i] = vec[i];
 		reflect_x(o), v = b2int(o);
 		if ( visited[v] != yes )
 			q.push(v), visited[v] = yes;
 		for ( i = 0; i < K; ++i ) o[i] = vec[i];
 		reflect_y(o), v = b2int(o);
 		if ( visited[v] != yes )
 			q.push(v), visited[v] = yes;
 		for ( i = 0; i < K; ++i ) o[i] = vec[i];
 		rotate(o), v = b2int(o);
 		if ( visited[v] != yes )
 			q.push(v), visited[v] = yes;
 	}
 }
 
 queue<unsigned int> Q;
 bool bfs( const unsigned int mask ) {
 	unsigned int u,v,w;
 	int i,j,k,l,t;
 
 	assert( bts[mask] == K );
 	gen_equiv_class(mask,e);
 
 	while ( !Q.empty() ) Q.pop();
 	for ( ++yes, u = 0; u < BIT(m*n); ++u )
 		if ( bts[u] == K && in_class[to_origin(u)] )
 			visited[u] = yes, Q.push(u);
 	/*
 	if ( mask == 11 && K == 3 && m == 2 && n == 3 ) {
 		printf("[%lu] This %lu %u\n",moves.size(),Q.size(),Q.front());
 		for ( i = 0; i < (int)moves.size(); ++i )
 			printf("move[%d] = %u\n",i,moves[i]);
 	}
 	*/
 	while ( !Q.empty() ) {
 		if ( (u=Q.front()) == MASK(m*n) ) return true;
 		for ( Q.pop(), i = 0; i < (int)moves.size(); ++i ) 
 			if ( !((v=moves[i])&u) )
 				if ( visited[w=u|v] != yes && w < BIT(m*n) )
 					visited[w] = yes, Q.push(w);
 	}
 	return visited[MASK(m*n)] == yes;
 }
 
 bool richard_wins() {
 	unsigned int u,v;
 	int sx,sy,i,j,k;
 	memset(connected,0,sizeof connected);
 	for ( k = m, m = n, u = 0; u < BIT(n*n); ++u ) {
 		if ( bts[u] != K ) continue ;
 		for ( i = 0; i < n*n; ++i )
 			if ( board[i/n][i%n]=((u>>i)&1) )
 				sx = i/n, sy = i%n;
 		assert( board[sx][sy] );
 		if ( ++yes && dfs(sx,sy) == K )
 			connected[u] = true;
 	}
 	for ( m = k, u = 0; u < BIT(n*n); ++u )
 		if ( bts[u] == K && connected[u] && !bfs(to_origin(u)) ) {
 			return true;
 		}
 	return false;
 }
 
 int main() {
 	int i,j,k,cs = 0,ts,sx,sy;
 	unsigned int u,v;
 #ifndef ONLINE_JUDGE
 	// freopen("input.txt","r",stdin);
 #endif
 	for ( u = 0; u < BIT(16); bts[u]=bts[u>>1]+(u&1), ++u );
 	for ( scanf("%d",&ts); ts-- && 3 == scanf("%d %d %d",&K,&m,&n) && printf("Case #%d: ",++cs); ) {
 		if ( m > n ) swap(m,n);
 		assert( m <= n );
 		for ( moves.clear(), u = 0; u < BIT(m*n); ++u ) {
 			if ( bts[u] != K ) continue ;
 			for ( sx=sy=-1, i = 0; i < m*n; ++i )
 				if ( board[i/n][i%n] = ((u>>i)&1) )
 					sx = i/n, sy = i%n;
 			assert( sx != -1 );
 			if ( ++yes && dfs(sx,sy) == K ) 
 				moves.push_back(u);
 		}
 		puts(richard_wins()?"RICHARD":"GABRIEL");
 	}
 	return 0;
 }
 
