#include <iostream>
 #include <fstream>
 #include <sstream>
 #include <vector>
 #include <string>
 #include <cmath>
 
 typedef std::vector<int> vector_int;
 typedef std::vector<std::string> vector_s;
 
 
 int biggest_smaller_divisor(int x) {
 	for (int i = std::floor(std::sqrt(x)); i > 0; --i) {
 		if (x % i == 0) {
 			return i;
 		}
 	}
 	return 0;
 }
 
 
 /*
 NOTE: if the check-functions return true, it is impossible for Gabriel to 
 	  fill the grid and Richard wins the game
 */
 
 
 //when x is greater or equal 7, you can create an omino with a hole 
 //which makes it impossible to fill the grid
 bool check_hole(int x) {
 	return x >= 7;
 }
 
 //when x is greater than r or c, you can choose an omino which is 
 //too long or too large for the grid
 bool check_area(int x, int r, int c) {
 	return (x > std::max(r,c) || biggest_smaller_divisor(x) > std::min(r,c));
 }
 
 bool check_divisibility(int x, int r, int c) {
 	return r*c % x != 0;
 }
 
 std::string check (int x, int r, int c) {
 	return (check_hole(x) || check_area(x,r,c) || check_divisibility(x,r,c)) ? "RICHARD" : "GABRIEL";
 }
 
 int main() {
 
 	int s_max;
 	vector_int s;
 	vector_s res;
 
 	std::ifstream input_file;
 	std::ofstream output_file;
 	unsigned int T;
 	
 	std::string line;
 
 	input_file.open("input.txt");
 	if (input_file.is_open()) {
 		std::getline(input_file,line);
 		T = std::stoi(line);
 
 		for (int i = 0; i < T; ++i) {
 			std::getline(input_file,line);
 			std::stringstream linestream(line);
 			int value;
 			s.clear();
 			while(linestream >> value) {
 				s.push_back(value);
 			}
 			int x = s.at(0);
 			int r = s.at(1);
 			int c = s.at(2);
 			res.push_back(check(x,r,c));
 		}
 	}
 	input_file.close();
 
 
 	//write result to output file
 	int index(0);
   	output_file.open ("output.txt");
   	for (auto& element : res) {
 			output_file << "Case #" << ++index <<": " << element << std::endl;
 	}
   	output_file.close();
 
 	return 0;
 }