#include <stdio.h>
 #include <string.h>
 #include <math.h>
 #define max(a,b) ((a) > (b) ? (a) : (b))
 #define min(a,b) ((a) < (b) ? (a) : (b))
 char board[21][21];
 char sharp[8][400][7][7];
 int s_map[8][400];
 int s_mcnt[8];
 int s_cnt[8];
 int n,r,c,max_x;
 int dir[4][2] = {{0,1},{1,0},{0,-1},{-1,0}};
 inline bool check(int x,int y){
     if(x < 0 || x >= r || y < 0 || y >= c){
         return false;
     }
     return true;
 }
 bool dfs(int x,int y,int rest,int k){
     if(k == r*c){
         if(rest == 0){
             return true;
         }
         return false;
     }
     if(rest > 0){
         for(int i = 0;i < 4;i++){
             int nx = x + dir[i][0];
             int ny = y + dir[i][1];
             if(check(nx,ny) && !board[nx][ny]){
                 board[nx][ny] = 1;
                 if(dfs(nx,ny,rest-1,k+1)){board[nx][ny] = 0;return true;}
                 board[nx][ny] = 0;
             }
         }
     }
     else{
         for(int i = 0;i < r;i++){
             for(int j = 0; j < c;j++){
                 if(!board[i][j]){
                     board[i][j] = 1;
                     if(dfs(i,j,n-1,k+1)){
                         board[i][j] = 0;
                         return true;
                     }
                     board[i][j] = 0;
                     return false;
                 }
             }
         }
     }
     return false;
 }
 bool checkSame(char a[7][7],char b[7][7]){
     for(int i = 0;i < 7;i++){
         for(int j = 0; j < 7;j++){
             if(a[i][j] != b[i][j]){
                 return false;
             }
         }
     }
     return true;
 }
 
 bool checkSim(char a[7][7],char b[7][7]){
     int ar,ac,br,bc;
     ar = ac = br = bc = 1;
     for(int i = 0;i < 7;i++){
         int ta = 0,tb = 0;
         for(int j = 0; j < 7;j++){
             if(a[i][j] != 0){ta = j+1;}
             if(b[i][j] != 0){tb = j+1;}
         }
         ac = max(ac,ta);
         bc = max(bc,tb);
         if(ta != 0){ar = i+1;}
         if(tb != 0){br = i+1;}
     }
     int f1 = 1,f2 = 1,f3 = 1,f4 = 1;
     int f5 = 1,f6 = 1,f7 = 1,f8 = 1;
     if(ar == br && ac == bc){
         for(int i = 0;i < ar;i++){
             for(int j = 0; j < ac;j++){
                 if(a[i][j] != b[i][ac-j-1]){
                     f1 = 0;
                 }
             }
         }
         for(int i = 0;i < ar;i++){
             for(int j = 0; j < ac;j++){
                 if(a[i][j] != b[ar-i-1][j]){
                     f2 = 0;
                 }
             }
         }
         for(int i = 0;i < ar;i++){
             for(int j = 0; j < ac;j++){
                 if(a[i][j] != b[ar-i-1][ac-j-1]){
                     f3 = 0;
                 }
             }
         }
         for(int i = 0;i < ar;i++){
             for(int j = 0; j < ac;j++){
                 if(a[i][j] != b[i][j]){
                     f4 = 0;
                 }
             }
         }
         if(f1 || f2 || f3 || f4){
             return true;
         }
     }
     if(ar == bc && ac == br){
         for(int i = 0;i < ar;i++){
             for(int j = 0; j < ac;j++){
                 if(a[i][j] != b[j][i]){
                     f5 = 0;
                 }
             }
         }
         for(int i = 0;i < ar;i++){
             for(int j = 0; j < ac;j++){
                 if(a[i][j] != b[ac-j-1][i]){
                     f6 = 0;
                 }
             }
         }
         for(int i = 0;i < ar;i++){
             for(int j = 0; j < ac;j++){
                 if(a[i][j] != b[j][ar-i-1]){
                     f7 = 0;
                 }
             }
         }
         for(int i = 0;i < ar;i++){
             for(int j = 0; j < ac;j++){
                 if(a[i][j] != b[ac-j-1][ar-i-1]){
                     f8 = 0;
                 }
             }
         }
         if(f5 || f6 || f7 || f8){
             return true;
         }
 
     }
     return false;
 }
 char tmp[7][7];
 void put(int k,int rest){
     if(rest == 0){
         for(int i = 0;i < s_cnt[k];i++){
             if(checkSame(sharp[k][i],tmp)){
                 return;
             }
         }
         memcpy(sharp[k][s_cnt[k]++],tmp,sizeof(tmp));
         // for(int i = 0;i < 7;i++){
         //     for(int j = 0; j < 7;j++){
         //         printf("%d",tmp[i][j]);
         //     }
         //     printf("\n");
         // }
         // printf("\n");
         return;
     }else{
         int max_r = (k-1)/2 + 1;
         for(int i = 0;i < max_r;i++){
             for(int j = 0; j < 7;j++){
                 if(!tmp[i][j]){
                     for(int ii = 0; ii < 4;ii++){
                         int ti = i + dir[ii][0];
                         int tj = j + dir[ii][1];
                         if(ti >= 0 && ti < max_r && tj >= 0 && tj < 7 && tmp[ti][tj]){
                             tmp[i][j] = 1;
                             put(k,rest-1);
                             tmp[i][j] = 0;
                         }
                     }
                 }
             }
         }
     }
 }
 bool solve(int n,int r,int c){
     int isCover[s_mcnt[n]+1];
     memset(isCover,0,sizeof(isCover));
     for(int i = 0; i < s_cnt[n];i++){
         for(int ii = 0;ii < 7;ii++){
             for(int jj = 0; jj < 7;jj++){
                 board[ii][jj] = sharp[n][i][ii][jj];
             }
         }
         for(int ii = 0;ii < r;ii++){
             for(int jj = 0; jj < c;jj++){
                 if(!board[ii][jj]){
                     for(int iii = 0; iii < 4 ;iii++){
                         int ti = ii + dir[iii][0];
                         int tj = ii + dir[iii][1];
                         if(check(ti,tj) && board[ti][tj]){
                             board[ti][tj] = 1;
                             if(dfs(ti,tj,n-1,n+1)){
                                 isCover[s_map[n][i]] = 1;
                             }
                         }
                     }
                 }
             }
         }
     }
     for(int i = 0;i < s_mcnt[n];i++){
         if(!isCover[i]){
             return false;
         }
     }
     return true;
 }
 int main(){
     freopen("test.in","r",stdin);
     freopen("small.out","w",stdout);
     int T;
     int tt = 1;
     scanf("%d",&T);
     memset(sharp,0,sizeof(sharp));
     for(int i = 1;i <= 6;i++){
         memset(tmp,0,sizeof(tmp));
         tmp[0][0] = 1;
         put(i,i-1);
         s_map[i][0] = 0;
         s_mcnt[i] = 1;
         for(int j = 1; j < s_cnt[i];j++){
             int f = 1;
             for(int k = 0; k < j; k++){
                 if(checkSim(sharp[i][j],sharp[i][k])){
                     s_map[i][j] = s_map[i][k];
                     f = 0;
                     break;
                 }
             }
             if(f){
                 s_map[i][j] = s_mcnt[i]++;
             }
         }
     }
     while(T--){
         scanf("%d %d %d",&n,&r,&c);
         if(c < r){int t = c;c=r;r=t;}
         max_x = (n-1)/2 + 1;
         memset(board,0,sizeof(board));
         if(r*c % n != 0 || max_x > r || n > c || n >= 7){
             printf("Case #%d: RICHARD\n",tt++);
             continue;   
         }
         if(solve(n,r,c)){
             printf("Case #%d: GABRIEL\n",tt++);
         }else{
             printf("Case #%d: RICHARD\n",tt++);
         }
     }
 }