#include <iostream>
 #include <fstream>
 #include <string>
 #include <vector>
 #include <sstream>
 #include <math.h>
 
 using namespace std;
 
 #define toDigit(c) (c-'0')
 int totalProblemNum;
 vector<vector<int>>  problemArray;
 
 vector<string> &split(const string &s, char delim, vector<string> &elems) {
 	stringstream ss(s);
 	string item;
 	while (getline(ss, item, delim)) {
 		elems.push_back(item);
 	}
 	return elems;
 }
 
 vector<string> split(const string &s, char delim) {
 	vector<string> elems;
 	split(s, delim, elems);
 	return elems;
 }
 
 void readTxtFile(string fileName){
 	string line;
 	ifstream myfile (fileName);
 	
 	if (myfile.is_open()){
 		bool isFirstLine=true;		
 		unsigned long stringLength=1;
 		unsigned long stringRepeatNum=1;
 		while ( getline (myfile,line) ){			
 			if (isFirstLine){
 				isFirstLine = false;
 				totalProblemNum = atoi(line.c_str());				
 			}else{				
 				
 				vector<string> tmpLine = split(line, ' ');
 				vector<int> tmpProblemArray;
 				for(int i=0; i<3; i++)
 					tmpProblemArray.push_back(atoi(tmpLine[i].c_str()));
 				problemArray.push_back(tmpProblemArray);				
 			}
 		}
 		myfile.close();
 	}
 
 	else cout << "Unable to open file"; 
 }
 
 //return false ==> RICHARD win
 bool OminousCompare(vector<int> tmpProblemArray){
 	int X = tmpProblemArray[0];
 	int R = tmpProblemArray[1];
 	int C = tmpProblemArray[2];
 
 	int totalArea = R*C;
 
 	if( (totalArea % X) != 0) return false;
 	if( X > 6) return false;
 	if( (X/2 > R) || (X/2 > C)) return false;
 
 
 	return true;
 }
 int main () {
 	
 	//read Problem txt file
 	readTxtFile("D-small-attempt0.txt");
 	cout << "\n" << "\n";
 
 	ofstream myfile ("problem4Result_small.txt");
 	if (myfile.is_open()){
 		for(int i = 0 ; i< totalProblemNum ; i++){							
 			OminousCompare(problemArray[i]);
 			
 			if (OminousCompare(problemArray[i]))
 				myfile << "Case #" << i+1 << ": GABRIEL" << "\n";		
 			else
 				myfile << "Case #" << i+1 << ": RICHARD" << "\n";					
 			
 		}
 	}
 	return 0;
 }