#include <errno.h>
 #include <stdio.h>
 #include <stdlib.h>
 
 int main(void)
 {
     FILE *in, *out;
     const char *GAB = "GABRIEL";
     const char *RICH = "RICHARD";
 
     //Replace with name of input file
     in = fopen("D-small-attempt2.in", "r");
 
     if(!in)
     {
         fputs("Error: Can not open input file.", stderr);
         exit(EXIT_FAILURE);
     }
 
     //Replace with name of output file
     out = fopen("output4.txt", "w");
 
     if(!out)
     {
         fputs("Error: Can not open output file.", stderr);
         exit(EXIT_FAILURE);
     }
 
     int test_size = 0;
 
     fscanf(in, " %i", &test_size);
 
     if(test_size < 1 || test_size > 100)
     {
         fputs("Error: Number of test cases is not in allowed range.", stderr);
         exit(EXIT_FAILURE);
     }
 
     for(int i = 0; i < test_size; i++)
     {
         int X = 0, R = 0, C = 0;
 
         fscanf(in, " %i", &X);
 
         if(X < 1 || X > 20)
         {
             fputs("Error: X is not in allowed range.", stderr);
             exit(EXIT_FAILURE);
         }
 
         fscanf(in, " %i", &R);
 
         if(R < 1 || R > 20)
         {
             fputs("Error: R is not in allowed range.", stderr);
             exit(EXIT_FAILURE);
         }
 
         fscanf(in, " %i", &C);
 
         if(C < 1 || C > 20)
         {
             fputs("Error: C is not in allowed range.", stderr);
             exit(EXIT_FAILURE);
         }
 
         if(X > 6 || R * C % X != 0 || (X == 4 && (R || C <= X / 2)))
         {
             fprintf(out, "Case #%i: %s\n", i + 1, RICH);
         }
         else
         {
             fprintf(out, "Case #%i: %s\n", i + 1, GAB);
         }
     }
 
     if(fclose(in))
     {
         fputs("Error: Can not close input file.", stderr);
         exit(EXIT_FAILURE);
     }
 
     if(fclose(out))
     {
         fputs("Error: Can not close input file.", stderr);
         exit(EXIT_FAILURE);
     }
 
     return EXIT_SUCCESS;
 }
